/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/* Benjamin Michotte Linux port, webmaster                              */
/*                                                                      */
/* Mail             :binny@ploksoftware.org                             */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCAnimation.h											*/
/*																		*/
/* Star Date   :03/15/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXCANIMATION_H__
#define __EXCANIMATION_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Object/Object3D/ExCObject3D.h"
//------------------------------------------------------------------------
#include "Object/Object3D/Gizmo/ExCGizmoLineBezier.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerCamera.h"
#include "Manager/ManagerObject/ExManagerModele.h"
#include "Manager/ManagerObject/ExManagerEntity.h"
#include "Manager/ExManagerId.h"

//------------------------------------------------------------------------
class ExCAnimation : public ExCObject3D
{
protected:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExManagerCamera				*ManagerCamera;
	ExManagerModel				*ManagerModel;
	ExManagerId					*ManagerId;
	ExManagerEntity				*ManagerEntity;

	struct AnimationStruct
	{
		ExCGizmoLineBezier					m_Line;
		float								m_Speed;
		ExCVec3D							m_AngleCtrlPoint0;
		bool								m_AngleCtrlPoint0Way;
		ExCVec3D							m_AngleCtrlPoint1;
		bool								m_AngleCtrlPoint1Way;
		ExCVec3D							m_AngleCtrlPoint2;
		bool								m_AngleCtrlPoint2Way;
		ExCVec3D							m_AngleCtrlPoint3;
		bool								m_AngleCtrlPoint3Way;
		ExCVec3D							m_AngleCtrlPoint4;
		bool								m_AngleCtrlPoint4Way;
		ExCAction							m_EndAction;
		float								m_NumberIter;
	};

	std::string							m_TargetObjectName;
	std::string							m_TargetObjectType;
	bool								m_ShowPath;
	ExCGizmoLineBezier					m_Line;
	float								m_Time;
	std::vector<ExCGizmoLineBezier>		m_VecLine;

	bool								m_Loop;
	
	
	int									m_CurrentAnimation;
	std::vector<AnimationStruct>		m_VecAnimation;
	
	bool								m_Pause;
public:
	ExCObject3D				*m_Object;
//------------------------------------------------------------------------
// Constructor // Destructor
//------------------------------------------------------------------------
	ExCAnimation();
	~ExCAnimation();
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	inline void SetManagerCamera(ExManagerCamera *Cam){ManagerCamera = Cam;}
	inline void SetManagerModel(ExManagerModel *Model){ManagerModel = Model;}
	inline void SetManagerId(ExManagerId *Id){ManagerId = Id;}
	inline void SetManagerEntity(ExManagerEntity *Entity){ManagerEntity = Entity;}

	void Draw(void);
	bool LoadFile(std::string FileName);
	void SetShowPathState(bool state);
	inline void SetPauseState(bool state){m_Pause=state;}
	inline bool GetPauseState(void){return m_Pause;} 
};
//------------------------------------------------------------------------
#endif //__ExCAnimation_H__
