/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 
 *
 */

#include "ExCEntity.h"

ExCEntity::ExCEntity(void)
{
Guard(ExCEntity::ExCEntity(void))
	SetName("ExCEntity");
	SetType(typeid(this).name());
	m_Visible=true;
UnGuard
}

ExCEntity::~ExCEntity(void)
{
Guard(ExCEntity::~ExCEntity(void))
UnGuard
}

void ExCEntity::Draw(void)
{
Guard(void ExCEntity::Draw(void))
	if(!m_Visible)return;
	glPushMatrix();
	glDisable(GL_LIGHTING);
		glTranslatef(m_Position.GetX(),m_Position.GetY(),m_Position.GetZ());


		/*glRotatef(m_Angle.GetX(),1,0,0);
		glRotatef(m_Angle.GetY(),0,1,0);
		glRotatef(m_Angle.GetZ(),0,0,1);
*/
		ExQuaternion qRotationY,qRotationX,qRotationZ,qresult;
		float matrix[16];

		qRotationX.CreateFromAxisAngle(1, 0, 0, m_Angle.GetX());
		qRotationY.CreateFromAxisAngle(0, 1, 0, m_Angle.GetY());
		qRotationZ.CreateFromAxisAngle(0, 0, 1, m_Angle.GetZ());

		qRotationY.CreateMatrix(matrix);
		glMultMatrixf(matrix);
		qRotationZ.CreateMatrix(matrix);
		glMultMatrixf(matrix);
		qRotationX.CreateMatrix(matrix);
		glMultMatrixf(matrix);


		glScalef(m_Scale.GetX(),m_Scale.GetY(),m_Scale.GetZ());
		if(strcmpi("ExManagerModel",m_ManagerType.data())==0)
		{
			ManagerModel->GetObject(m_MeshId)->m_Visible=true;
			ManagerModel->GetObject(m_MeshId)->Draw();
			ManagerModel->GetObject(m_MeshId)->m_Visible=false;
		}
		if(strcmpi("ExManagerMesh",m_ManagerType.data())==0)
		{
			ManagerMesh->GetObject(m_MeshId)->m_Visible=true;
			ManagerMesh->GetObject(m_MeshId)->Draw();
			ManagerMesh->GetObject(m_MeshId)->m_Visible=false;
		}


	glPopMatrix();
UnGuard
}

bool ExCEntity::LoadFile(std::string FileName)
{
Guard(bool ExCEntity::LoadFile(std::string FileName))

	//char			buffer[255];
	//sprintf(buffer, "../Data/Animation/%s", FileName.data());
	std::ifstream fin;
	std::string buffstring;
	char b[256];
	fin.open(FileName.data(),std::ios::in);
	if(fin.is_open())
	{
		try
		{
			//----Read Type
			memset(b,0,255);fin.getline(b,256,'\n');
			//----Read File property
			memset(b,0,255);fin.getline(b,256,'\n');
			m_FileProperty=ExNihilo::ExtracValueFromSring(b,"<ObjectProperty>","<#ObjectProperty>");
			//----Read File MEsh
			memset(b,0,255);fin.getline(b,256,'\n');
			m_FileMesh=ExNihilo::ExtracValueFromSring(b,"<ObjectGraphic>","<#ObjectGraphic>");
			//----Read File Gizmo
			memset(b,0,255);fin.getline(b,256,'\n');
			m_FileGizmo=ExNihilo::ExtracValueFromSring(b,"<CollisionGizmo>","<#CollisionGizmo>");
			//read property later in other file
			//----Read File Name
			memset(b,0,255);fin.getline(b,256,'\n');
			m_ObjectName=ExNihilo::ExtracValueFromSring(b,"<ObjectName>","<#ObjectName>");
			//---- Read Position
			memset(b,0,255);fin.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<Position>","<#Position>");
			m_Position.SetValue(ExNihilo::ExtractFloatValueFromSring(buffstring,"<X>","<#X>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Y>","<#Y>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Z>","<#Z>"));
			//---- Read Angle
			memset(b,0,255);fin.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<Angle>","<#Angle>");
			m_Angle.SetValue(ExNihilo::ExtractFloatValueFromSring(buffstring,"<X>","<#X>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Y>","<#Y>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Z>","<#Z>"));
			//---- Read scale
			memset(b,0,255);fin.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<Scale>","<#Scale>");
			m_Scale.SetValue(ExNihilo::ExtractFloatValueFromSring(buffstring,"<X>","<#X>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Y>","<#Y>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Z>","<#Z>"));
			fin.close();
		}
		catch(ExCExpStringNotFound)
		{
			std::cout<<"ExCExpStringNotFound"<<std::endl;
		}
		catch(...)
		{
			std::cout<<"ExCExpFileReadError"<<std::endl;
			throw ExCExpFileReadError();
		}
	}else throw   ExCExpFileNotFound();

	//Find manager where is the object and get pointer to object
	try
	{

		if(strcmpi(ExNihilo::GetFileExtension(m_FileMesh).data(),"exme")==0)
		{
			m_ManagerType="ExManagerMesh";
			m_MeshId=ManagerMesh->Load(m_FileMesh);
			ManagerMesh->GetObject(m_MeshId)->m_Visible=false;
			return true;
		}
		if(strcmpi(ExNihilo::GetFileExtension(m_FileMesh).data(),"3ds")==0)
		{
			m_ManagerType="ExManagerModel";
			m_MeshId=ManagerModel->Load(m_FileMesh);
			ManagerModel->GetObject(m_MeshId)->m_Visible=false;
			return true;
		}
		if(strcmpi(ExNihilo::GetFileExtension(m_FileMesh).data(),"md2")==0)
		{
			m_ManagerType="ExManagerModel";
			m_MeshId=ManagerModel->Load(m_FileMesh);
			ManagerModel->GetObject(m_MeshId)->m_Visible=false;
			return true;
		}
	}catch (...)
	{
		std::cout<<"Wrong Graphic object chek name or object type in your graphic file"<<std::endl;
		return false;
	}
	return false;

	//read 3ds
	
	//read gizmo

	return true;
UnGuard
}

bool ExCEntity::LoadFile(std::ifstream *fin)
{
Guard(bool ExCEntity::LoadFile(std::ifstream *fin))
	std::string buffstring;
	char b[256];
//	fin.open(FileName.data(),std::ios::in);
	if(fin->is_open())
	{
		try
		{
			//----Read Type
			memset(b,0,255);fin->getline(b,256,'\n');
			//----Read File property
			memset(b,0,255);fin->getline(b,256,'\n');
			m_FileProperty=ExNihilo::ExtracValueFromSring(b,"<ObjectProperty>","<#ObjectProperty>");
			//----Read File MEsh
			memset(b,0,255);fin->getline(b,256,'\n');
			m_FileMesh=ExNihilo::ExtracValueFromSring(b,"<ObjectGraphic>","<#ObjectGraphic>");
			//----Read File Gizmo
			memset(b,0,255);fin->getline(b,256,'\n');
			m_FileGizmo=ExNihilo::ExtracValueFromSring(b,"<CollisionGizmo>","<#CollisionGizmo>");
			//read property later in other file
			//----Read File Name
			memset(b,0,255);fin->getline(b,256,'\n');
			m_ObjectName=ExNihilo::ExtracValueFromSring(b,"<ObjectName>","<#ObjectName>");
			//---- Read Position
			memset(b,0,255);fin->getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<Position>","<#Position>");
			m_Position.SetValue(ExNihilo::ExtractFloatValueFromSring(buffstring,"<X>","<#X>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Y>","<#Y>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Z>","<#Z>"));
			//---- Read Angle
			memset(b,0,255);fin->getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<Angle>","<#Angle>");
			m_Angle.SetValue(ExNihilo::ExtractFloatValueFromSring(buffstring,"<X>","<#X>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Y>","<#Y>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Z>","<#Z>"));
			//---- Read scale
			memset(b,0,255);fin->getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<Scale>","<#Scale>");
			m_Scale.SetValue(ExNihilo::ExtractFloatValueFromSring(buffstring,"<X>","<#X>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Y>","<#Y>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Z>","<#Z>"));
		
		}
		catch(ExCExpStringNotFound)
		{
			std::cout<<"ExCExpStringNotFound"<<std::endl;
		}
		catch(...)
		{
			std::cout<<"ExCExpFileReadError"<<std::endl;
			throw ExCExpFileReadError();
		}
	}else throw   ExCExpFileNotFound();

	//Find manager where is the object and get pointer to object
	try
	{

		if(strcmpi(ExNihilo::GetFileExtension(m_FileMesh).data(),"exme")==0)
		{
			m_ManagerType="ExManagerMesh";
			m_MeshId=ManagerMesh->Load(m_FileMesh);
			ManagerMesh->GetObject(m_MeshId)->m_Visible=false;
			return true;
		}
		if(strcmpi(ExNihilo::GetFileExtension(m_FileMesh).data(),"3ds")==0)
		{
			m_ManagerType="ExManagerModel";
			m_MeshId=ManagerModel->Load(m_FileMesh);
			ManagerModel->GetObject(m_MeshId)->m_Visible=false;
			return true;
		}
		if(strcmpi(ExNihilo::GetFileExtension(m_FileMesh).data(),"md2")==0)
		{
			m_ManagerType="ExManagerModel";
			m_MeshId=ManagerModel->Load(m_FileMesh);
			ManagerModel->GetObject(m_MeshId)->m_Visible=false;
			return true;
		}
	}catch (...)
	{
		std::cout<<"Wrong Graphic object chek name or object type in your graphic file"<<std::endl;
		return false;
	}
	return false;

	//read 3ds

	//read gizmo

	return true;
	UnGuard
}