/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 
 *
 */

#include "ExCGroupEntity.h"

ExCGroupEntity::ExCGroupEntity(void)
{
Guard(ExCGroupEntity::ExCGroupEntity(void))
	SetName("ExCGroupEntity");
	SetType(typeid(this).name());
	m_Visible=true;
	m_HasGroupe=false;
	m_GroupeName="NONE";
UnGuard
}

ExCGroupEntity::~ExCGroupEntity(void)
{
Guard(ExCGroupEntity::~ExCGroupEntity(void))
UnGuard
}

void ExCGroupEntity::Draw(void)
{
Guard(void ExCGroupEntity::Draw(void))
	if(!m_Visible)return;
	glPushMatrix();
	glDisable(GL_LIGHTING);
		glTranslatef(m_Position.GetX(),m_Position.GetY(),m_Position.GetZ());


		/*glRotatef(m_Angle.GetX(),1,0,0);
		glRotatef(m_Angle.GetY(),0,1,0);
		glRotatef(m_Angle.GetZ(),0,0,1);
*/
		ExQuaternion qRotationY,qRotationX,qRotationZ,qresult;
		float matrix[16];

		qRotationX.CreateFromAxisAngle(1, 0, 0, m_Angle.GetX());
		qRotationY.CreateFromAxisAngle(0, 1, 0, m_Angle.GetY());
		qRotationZ.CreateFromAxisAngle(0, 0, 1, m_Angle.GetZ());

		qRotationY.CreateMatrix(matrix);
		glMultMatrixf(matrix);
		qRotationZ.CreateMatrix(matrix);
		glMultMatrixf(matrix);
		qRotationX.CreateMatrix(matrix);
		glMultMatrixf(matrix);


		glScalef(m_Scale.GetX(),m_Scale.GetY(),m_Scale.GetZ());
		//std::cout<<"Drw:EntityGroupe:"<<m_VecEntity.size()<<std::endl;
		for( unsigned int i=0;i<m_VecEntity.size();i++)
		{
			m_VecEntity.at(i).Draw();
			//std::cout<<"Drw:"<<m_VecEntity.at(i).GetName()<<std::endl;;
		}
	glPopMatrix();
UnGuard
}

bool ExCGroupEntity::LoadFile(std::string FileName)
{
Guard(bool ExCGroupEntity::LoadFile(std::string FileName))

	//char			buffer[255];
	//sprintf(buffer, "../Data/Animation/%s", FileName.data());
	ExCEntity tmpEntity;
	std::ifstream fin;
	std::string buffstring;
	char b[256];
	fin.open(FileName.data(),std::ios::in);
	if(fin.is_open())
	{
		try
		{
			//----Read Type
			memset(b,0,255);fin.getline(b,256,'\n');
			//----Read File property
			memset(b,0,255);fin.getline(b,256,'\n');
			m_FileProperty=ExNihilo::ExtracValueFromSring(b,"<ObjectProperty>","<#ObjectProperty>");
			//----Read File MEsh
			memset(b,0,255);fin.getline(b,256,'\n');
			m_FileMesh=ExNihilo::ExtracValueFromSring(b,"<ObjectGraphic>","<#ObjectGraphic>");
			//----Read File Gizmo
			memset(b,0,255);fin.getline(b,256,'\n');
			m_FileGizmo=ExNihilo::ExtracValueFromSring(b,"<CollisionGizmo>","<#CollisionGizmo>");
			//read property later in other file
			//----Read File Name
			memset(b,0,255);fin.getline(b,256,'\n');
			m_ObjectName=ExNihilo::ExtracValueFromSring(b,"<ObjectName>","<#ObjectName>");
			//---- Read Position
			memset(b,0,255);fin.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<Position>","<#Position>");
			m_Position.SetValue(ExNihilo::ExtractFloatValueFromSring(buffstring,"<X>","<#X>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Y>","<#Y>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Z>","<#Z>"));
			//---- Read Angle
			memset(b,0,255);fin.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<Angle>","<#Angle>");
			m_Angle.SetValue(ExNihilo::ExtractFloatValueFromSring(buffstring,"<X>","<#X>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Y>","<#Y>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Z>","<#Z>"));
			//---- Read scale
			memset(b,0,255);fin.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<Scale>","<#Scale>");
			m_Scale.SetValue(ExNihilo::ExtractFloatValueFromSring(buffstring,"<X>","<#X>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Y>","<#Y>"),
				ExNihilo::ExtractFloatValueFromSring(buffstring,"<Z>","<#Z>"));
			//read number entity
			memset(b,0,255);fin.getline(b,256,'\n');
			m_NumberEntity=ExNihilo::ExtractIntValueFromSring(b,"<NumberEntity>","<#NumberEntity>");
			//read entity
			for(int i=0;i<m_NumberEntity;i++)
			{
				//----Read Type
				memset(b,0,255);fin.getline(b,256,'\n');
				//----Read File property
				memset(b,0,255);fin.getline(b,256,'\n');
				tmpEntity.m_FileProperty=ExNihilo::ExtracValueFromSring(b,"<ObjectProperty>","<#ObjectProperty>");
				//----Read File MEsh
				memset(b,0,255);fin.getline(b,256,'\n');
				tmpEntity.m_FileMesh=ExNihilo::ExtracValueFromSring(b,"<ObjectGraphic>","<#ObjectGraphic>");
				//----Read File Gizmo
				memset(b,0,255);fin.getline(b,256,'\n');
				tmpEntity.m_FileGizmo=ExNihilo::ExtracValueFromSring(b,"<CollisionGizmo>","<#CollisionGizmo>");
				//read property later in other file
				//----Read File Name
				memset(b,0,255);fin.getline(b,256,'\n');
				tmpEntity.SetName(ExNihilo::ExtracValueFromSring(b,"<ObjectName>","<#ObjectName>"));
				//---- Read Position
				memset(b,0,255);fin.getline(b,256,'\n');
				buffstring=ExNihilo::ExtracValueFromSring(b,"<Position>","<#Position>");
				tmpEntity.m_Position.SetValue(ExNihilo::ExtractFloatValueFromSring(buffstring,"<X>","<#X>"),
					ExNihilo::ExtractFloatValueFromSring(buffstring,"<Y>","<#Y>"),
					ExNihilo::ExtractFloatValueFromSring(buffstring,"<Z>","<#Z>"));
				//---- Read Angle
				memset(b,0,255);fin.getline(b,256,'\n');
				buffstring=ExNihilo::ExtracValueFromSring(b,"<Angle>","<#Angle>");
				tmpEntity.m_Angle.SetValue(ExNihilo::ExtractFloatValueFromSring(buffstring,"<X>","<#X>"),
					ExNihilo::ExtractFloatValueFromSring(buffstring,"<Y>","<#Y>"),
					ExNihilo::ExtractFloatValueFromSring(buffstring,"<Z>","<#Z>"));
				//---- Read scale
				memset(b,0,255);fin.getline(b,256,'\n');
				buffstring=ExNihilo::ExtracValueFromSring(b,"<Scale>","<#Scale>");
				tmpEntity.m_Scale.SetValue(ExNihilo::ExtractFloatValueFromSring(buffstring,"<X>","<#X>"),
					ExNihilo::ExtractFloatValueFromSring(buffstring,"<Y>","<#Y>"),
					ExNihilo::ExtractFloatValueFromSring(buffstring,"<Z>","<#Z>"));
				//Find manager where is the object and get pointer to object
				try
				{
					tmpEntity.SetManagerGizmo(ManagerGizmo);
					tmpEntity.SetManagerMesh(ManagerMesh);
					tmpEntity.SetManagerModel(ManagerModel);
					tmpEntity.SetManagerId(ManagerId);
					std::cout<<tmpEntity.m_FileMesh<<std::endl;
					if(strcmpi(ExNihilo::GetFileExtension(tmpEntity.m_FileMesh).data(),"exme")==0)
					{
						tmpEntity.m_ManagerType="ExManagerMesh";
						tmpEntity.m_MeshId=ManagerMesh->Load(tmpEntity.m_FileMesh);
						ManagerMesh->GetObject(tmpEntity.m_MeshId)->m_Visible=false;
						return true;
					}
					if(strcmpi(ExNihilo::GetFileExtension(tmpEntity.m_FileMesh).data(),"3ds")==0)
					{
						tmpEntity.m_ManagerType="ExManagerModel";
						tmpEntity.m_MeshId=ManagerModel->Load(tmpEntity.m_FileMesh);
						ManagerModel->GetObject(tmpEntity.m_MeshId)->m_Visible=false;
						
					}
				}catch (...)
				{
					std::cout<<"Wrong Graphic object chek name or object type in your graphic file"<<std::endl;
					
				}
				m_VecEntity.push_back(tmpEntity);
			}
			
			fin.close();
		}
		catch(ExCExpStringNotFound)
		{
			std::cout<<"ExCExpStringNotFound"<<std::endl;
		}
		catch(...)
		{
			std::cout<<"ExCExpFileReadError"<<std::endl;
			throw ExCExpFileReadError();
		}
	}else throw   ExCExpFileNotFound();
	return true;
UnGuard
}