/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCObject.cpp,v 1.21 2002/12/03 22:40:03 data Exp $
 *
 */

#include "ExCObject.h"

// Construction/Destruction

ExCObject::ExCObject()
{
	SetName("EXCOBJECTERROR");
	SetType(typeid(this).name());
	SetId(-1);

}

ExCObject::~ExCObject()
{

}

ExCObject::ExCObject(std::string FileName)
{
	ExCObject();
	LoadFile(FileName);
}

void ExCObject::SetIdName(ExNihilo::IdName idname)
{
	SetName(idname.second);
	SetId(idname.first);
}

bool ExCObject::LoadFile(std::string FileName)
{
Guard(bool ExCObject::LoadFile(std::string FileName))
	return true;
UnGuard
}  

void ExCObject::Draw(void)
{
Guard(void ExCObject::Draw(void))
UnGuard
}  

void ExCObject::SetFlux(std::ostrstream *consol,ExCFluxAction *action)
{
	Consol=consol;
	FluxAction=action;
}

