/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCObject.h												*/
/*																		*/
/* Start Date   :19/11/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXOBJECT_H__
#define __EXOBJECT_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
#include "ExNihiloNameSpace.h"
//------------------------------------------------------------------------
#include "Flux/ExCFluxAction.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
class ExCObject  
{
protected:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExNihilo::ExId			m_ObjectId;
	std::string				m_ObjectName;
	std::string				m_ObjectFileName;
	std::string				m_ObjectType;
public:
	std::ostrstream *Consol;
	ExCFluxAction	*FluxAction;
//------------------------------------------------------------------------
// Constructor // Destructor
//------------------------------------------------------------------------
	ExCObject();
	ExCObject(std::string FileName);
	virtual ~ExCObject();
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	void SetFlux(std::ostrstream *consol,ExCFluxAction *action);

	virtual void Draw(void);
	virtual bool LoadFile(std::string FileName);
	
	void SetIdName(ExNihilo::IdName idname);
	inline ExNihilo::ExId GetId(void){return m_ObjectId;}
	inline std::string GetName(void){return m_ObjectName;}
	inline std::string GetFileName(void){return m_ObjectFileName;}
	inline std::string GetType(void){return m_ObjectType;}
	inline void SetId(ExNihilo::ExId Id){m_ObjectId=Id;}
	inline void SetName(std::string	 Name){m_ObjectName = Name;}
	inline void SetFileName(std::string	 FileName){m_ObjectFileName = FileName;}
	inline void SetType(std::string	 Type){m_ObjectType = Type;}
};
//------------------------------------------------------------------------
#endif // __EXOBJECT_H__
