/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCTexture.h											*/
/*																		*/
/* Star Date   :03/15/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXCTEXTURE_H__
#define __EXCTEXTURE_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Object/ExCObject.h"
//------------------------------------------------------------------------
#include "Tools/ExCImageLoader.h"
//------------------------------------------------------------------------
class ExCTexture : public ExCObject 
{
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
protected:
	// ARB_texture_compression
	PFNGLCOMPRESSEDTEXIMAGE3DARBPROC    glCompressedTexImage3DARB;
	PFNGLCOMPRESSEDTEXIMAGE2DARBPROC    glCompressedTexImage2DARB;
	PFNGLCOMPRESSEDTEXIMAGE1DARBPROC    glCompressedTexImage1DARB;
	PFNGLCOMPRESSEDTEXSUBIMAGE3DARBPROC glCompressedTexSubImage3DARB;
	PFNGLCOMPRESSEDTEXSUBIMAGE2DARBPROC glCompressedTexSubImage2DARB;
	PFNGLCOMPRESSEDTEXSUBIMAGE1DARBPROC glCompressedTexSubImage1DARB;
	PFNGLGETCOMPRESSEDTEXIMAGEARBPROC   glGetCompressedTexImageARB;

	int			m_Anisotropy_level;
	bool		m_Anisotropy;
	bool		m_SGIS_Mimap;
	bool		m_ARB_Texture_Compression;

public:
	GLuint			m_Texture;
	int			m_Compression;
	ExCImageLoader	*m_Image;
//------------------------------------------------------------------------
// Constructor // Destructor
//------------------------------------------------------------------------
	ExCTexture(void);
	ExCTexture(std::string FileName);
	~ExCTexture(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
    void SetName(std::string	 Name);
	bool LoadFile(std::string FileName);
	bool SaveFile(std::string FileName,int width,int height);
	void SetActive(void);
	inline GLuint GetGlTextureId(void){return m_Texture;}
	inline void SetAnisotropyLevel(bool state,int level){m_Anisotropy=state;m_Anisotropy_level=level;}
	inline void SetSGISMipMap(bool state){m_SGIS_Mimap=state;}
	inline void SetTextureCompression(bool state){m_ARB_Texture_Compression=state;}
};
//------------------------------------------------------------------------
#endif //__EXCTEXTURE_H__
