/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCInterface.cpp,v 1.6 2002/11/24 11:59:00 data Exp $
 *
 */

#include "ExCInterface.h"

ExCInterface::ExCInterface(void)
{
Guard(ExCInterface::ExCInterface(void))
	m_ShowRegion=true;
	m_State=true;
	SetName("ExCInterface");
	SetType(typeid(this).name());
UnGuard
}

ExCInterface::ExCInterface(std::string FileName)
{
Guard(ExCInterface::ExCInterface(std::string FileName))
	m_ShowRegion=true;
	m_State=true;
	LoadFile(FileName);
UnGuard
}

ExCInterface::~ExCInterface(void)
{
Guard(ExCInterface::~ExCInterface(void))
UnGuard
}

bool ExCInterface::LoadFile(std::string FileName)
{
Guard(bool ExCInterface::LoadFile(std::string FileName))
	char			buffer[255];
#ifdef UNIX_SRC
	sprintf(buffer, PREFIX "/ExNihilo/Data/Interface/%s", FileName.data());
#else
	sprintf(buffer, "../Data/Interface/%s", FileName.data());
#endif
	std::ifstream fin;
	std::string buffstring;
	char b[256];
	fin.open(buffer,std::ios::in);
	if(fin.is_open())
	{
		try
		{
			//----Read image
			memset(b,0,255);
			fin.getline(b,256,'\n');
			m_Texture=ExNihilo::ExtracValueFromSring(b,"<Image>","<#Image>");
			//----Read mask
            memset(b,0,255);
			fin.getline(b,256,'\n');			
			m_TextureMask=ExNihilo::ExtracValueFromSring(b,"<Mask>","<#Mask>");
			//----Read resolution
            memset(b,0,255);
			fin.getline(b,256,'\n');			
			buffstring=ExNihilo::ExtracValueFromSring(b,"<Mask>","<#Mask>");
			m_DefaultResolutionX=ExNihilo::ExtractIntValueFromSring(buffstring,"<X>","<#X>");
			m_DefaultResolutionY=ExNihilo::ExtractIntValueFromSring(buffstring,"<Y>","<#Y>");
			//----Read all command
			do
			{
				memset(b,0,255);
				fin.getline(b,256,'\n');
				try
				{
					ActionCommand actcmd;
					buffstring=ExNihilo::ExtracValueFromSring(b,"<Interface_Action>","<#Interface_Action>");
					actcmd.m_Action=ExNihilo::ExtractIntValueFromSring(buffstring,"<Action>","<#Action>");
					actcmd.m_Command=ExNihilo::ExtractIntValueFromSring(buffstring,"<Command>","<#Command>");
					actcmd.m_Param=ExNihilo::ExtracValueFromSring(buffstring,"<Param>","<#Param>");
					actcmd.m_MouseXup=ExNihilo::ExtractIntValueFromSring(buffstring,"<TopX>","<#TopX>");
					actcmd.m_MouseYup=ExNihilo::ExtractIntValueFromSring(buffstring,"<TopY>","<#TopY>");
					actcmd.m_MouseXdown=ExNihilo::ExtractIntValueFromSring(buffstring,"<BottomX>","<#BottomX>");
					actcmd.m_MouseYdown=ExNihilo::ExtractIntValueFromSring(buffstring,"<BottomY>","<#BottomY>");
					m_VecActionCommand.push_back(actcmd);
				}catch(ExCExpStringNotFound){}
			}while(!fin.eof());
			fin.close();
		}catch(...){throw ExCExpFileReadError();}
	}else throw   ExCExpFileNotFound();
	ManagerTexture->Add(m_Texture);
	ManagerTexture->Add(m_TextureMask);
	return true;
UnGuard
}

void ExCInterface::Draw(void)
{
Guard(void ExCInterface::Draw(void))
    glPushMatrix();
	ExNihilo::EnterOrthoMode();
	
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);
	glColor4f(1, 1, 1, 1);
	glDisable(GL_DEPTH_TEST);
	glBlendFunc(GL_DST_COLOR,GL_ZERO);
	glEnable(GL_BLEND);											
	
	ManagerTexture->SetCurrentObject(m_TextureMask);
	
	glBegin(GL_QUADS);
		glTexCoord2f(0.0f, 1.0f);	glVertex2f(0, 0);
		glTexCoord2f(0.0f, 0.0f);	glVertex2f(0,glutGet(GLUT_WINDOW_HEIGHT));
		glTexCoord2f(1.0f, 0.0f);	glVertex2f(glutGet(GLUT_WINDOW_WIDTH),glutGet(GLUT_WINDOW_HEIGHT));
		glTexCoord2f(1.0f, 1.0f);	glVertex2f(glutGet(GLUT_WINDOW_WIDTH), 0);
	glEnd();	

	glBlendFunc(GL_ONE,GL_ONE);
	ManagerTexture->SetCurrentObject(m_Texture);
	
	glBegin(GL_QUADS);
		glTexCoord2f(0.0f, 1.0f);	glVertex2f(0, 0);
		glTexCoord2f(0.0f, 0.0f);	glVertex2f(0,glutGet(GLUT_WINDOW_HEIGHT));
		glTexCoord2f(1.0f, 0.0f);	glVertex2f(glutGet(GLUT_WINDOW_WIDTH),glutGet(GLUT_WINDOW_HEIGHT));
		glTexCoord2f(1.0f, 1.0f);	glVertex2f(glutGet(GLUT_WINDOW_WIDTH), 0);
    glEnd();	
	
	glDisable(GL_BLEND);
	glDisable(GL_TEXTURE_2D);
	glEnable(GL_DEPTH_TEST);
	
	/*
	if(m_ShowRegion)
	{
		int i=0;
		for(m_ItVecActionCommand=m_VecActionCommand.begin();m_ItVecActionCommand!=m_VecActionCommand.end();m_ItVecActionCommand++,i++)
		{
			
			double Xup,Yup,Xdo,Ydo,cofx=1,cofy=1;
			//Xup=((double)m_ItVecActionCommand->m_MouseXup/m_DefaultResolutionX)*ManagerWindow->GetResolutionX();
			//Yup=((double)m_ItVecActionCommand->m_MouseYup/m_DefaultResolutionY)*ManagerWindow->GetResolutionY();
			//Xdo=((double)m_ItVecActionCommand->m_MouseXdown/m_DefaultResolutionX)*ManagerWindow->GetResolutionX();
			//Ydo=((double)m_ItVecActionCommand->m_MouseYdown/m_DefaultResolutionY)*ManagerWindow->GetResolutionY();
			
			
			
			//cout<<"Current resolution X:"<<ManagerWindow->GetResolutionX()<<endl;
			//cout<<"Current resolution Y:"<<ManagerWindow->GetResolutionY()<<endl;
			//cout<<"Default X:"<<m_DefaultResolutionX<<endl;
			//cout<<"Default Y:"<<m_DefaultResolutionY<<endl;
			if(cofx==0)cofx=1;
			if(cofy==0)cofy=1;
			cofx=(ManagerWindow->GetResolutionX()/m_DefaultResolutionX);		
			cofy=(ManagerWindow->GetResolutionY()/m_DefaultResolutionY);
			//cout<<"cofx :"<<cofx<<endl;
			//cout<<"cofy :"<<cofy<<endl;
			

			
			
			Xup=(m_ItVecActionCommand->m_MouseXup)*cofx;
			Yup=(m_ItVecActionCommand->m_MouseYup)*cofy;
			Xdo=(m_ItVecActionCommand->m_MouseXdown)*cofx;
			Ydo=(m_ItVecActionCommand->m_MouseYdown)*cofy;
			
			if(i%1==0){glColor3f((float)i/10,1.0f-((float)i/10),1.0f);}
			if(i%2==0){glColor3f(1.0f,1.0f-((float)i/10),(float)1/10);}
			if(i%3==0){glColor3f(1.0f-((float)i/10),1.0f,(float)1/10);}
			glBegin(GL_LINE_LOOP);
				glVertex2f(Xdo,Ydo);
				glVertex2f(Xdo,Yup);
				glVertex2f(Xup,Yup);
				glVertex2f(Xup,Ydo);
			glEnd();
		}
	}
	glEnable(GL_LIGHTING);*/
	ExNihilo::LeaveOrthoMode();
	glPopMatrix();
UnGuard
}

ExCAction ExCInterface::InputCommand(int command,int mousex,int mousey)
{
Guard(ExCAction ExCInterface::InputCommand(int command,int mousex,int mousey))
	int CntAct=0;
	ExCAction RetAct;
	
	for(m_ItVecActionCommand=m_VecActionCommand.begin();m_ItVecActionCommand!=m_VecActionCommand.end();m_ItVecActionCommand++)
	{
		if(m_ItVecActionCommand->m_Command==command)
		{
			if(m_ItVecActionCommand->m_MouseXup<0)
			{
				if(CntAct>0)
				{
					ExCAction	*RecursifActA;
					ExCAction	*RecursifActB;
					RecursifActA=&RetAct;
					for(int i=0;i<CntAct;i++)
					{
						if(RecursifActA->m_NextAction==NULL)
						{
							RecursifActA->m_NextAction=new ExCAction;
							RecursifActB=RecursifActA->m_NextAction;
							RecursifActB->m_Action=m_ItVecActionCommand->m_Action;
							RecursifActB->SetParam(m_ItVecActionCommand->m_Param);
						}
						RecursifActA=RecursifActA->m_NextAction;
					}
					CntAct++;
				}else
				{
					RetAct.m_Action=m_ItVecActionCommand->m_Action;
					RetAct.SetParam(m_ItVecActionCommand->m_Param);
					CntAct++;
				}
			}else
			{
				double Xup,Yup,Xdo,Ydo,Mx,My;
				Xup=((double)m_ItVecActionCommand->m_MouseXup/ManagerWindow->GetResolutionX());
				Yup=((double)m_ItVecActionCommand->m_MouseYup/ManagerWindow->GetResolutionY());
				Xdo=((double)m_ItVecActionCommand->m_MouseXdown/ManagerWindow->GetResolutionX());
				Ydo=((double)m_ItVecActionCommand->m_MouseYdown/ManagerWindow->GetResolutionY());
				Mx=((double)mousex/ManagerWindow->GetResolutionX());
				My=((double)mousey/ManagerWindow->GetResolutionY());

				/*cout<<"Resolution "<<ManagerWindow->GetResolutionX()<<" "<<ManagerWindow->GetResolutionY()<<endl;
				cout<<"Xup :"<<Xup<<endl;
				cout<<"Yup :"<<Yup<<endl;
				cout<<"Xdo :"<<Xdo<<endl;
				cout<<"Ydo :"<<Ydo<<endl;
				cout<<"Mx  :"<<Mx<<endl;
				cout<<"My  :"<<My<<endl;
				*/
				
				if((Xup>Mx)&&(Xdo<Mx)&&(Ydo<My)&&(Yup>My))
				{
					std::cout<<"clik dedans"<<std::endl;
					if(CntAct>0)
					{
						ExCAction	*RecursifActA;
						ExCAction	*RecursifActB;
						RecursifActA=&RetAct;
						for(int i=0;i<CntAct;i++)
						{
							if(RecursifActA->m_NextAction==NULL)
							{
								RecursifActA->m_NextAction=new ExCAction;
								RecursifActB=RecursifActA->m_NextAction;
								RecursifActB->m_Action=m_ItVecActionCommand->m_Action;
								RecursifActB->SetParam(m_ItVecActionCommand->m_Param);
							}
							RecursifActA=RecursifActA->m_NextAction;
						}
						CntAct++;
					}else
					{
						RetAct.m_Action=m_ItVecActionCommand->m_Action;
						RetAct.SetParam(m_ItVecActionCommand->m_Param);
						CntAct++;
					}
				}else
				{
					std::cout<<"click hors coordone"<<std::endl;
				}
			}
		}
	}
	if(CntAct==0)
	{
		RetAct.m_Action=NOTHING;
		RetAct.SetParam("NULL");
	}

	return RetAct;
UnGuard
}
