/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCInterface.h											*/
/*																		*/
/* Start Date   :04/20/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXCINTERFACE_H__
#define __EXCINTERFACE_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
#include "ExCAction.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Manager/ExManagerWindow.h"
#include "Manager/ManagerObject/ExManagerTexture.h"
//------------------------------------------------------------------------
#include "Object/Object2D/ExCObject2D.h"
//------------------------------------------------------------------------
class ExCInterface   : public ExCObject2D
{
private:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExManagerWindow		*ManagerWindow;
	ExManagerTexture	*ManagerTexture;
	std::string			m_Texture;
	std::string			m_TextureMask;
	int					m_NumInterface;
	int					m_DefaultResolutionX;
	int					m_DefaultResolutionY;
	bool				m_ShowRegion;
	bool				m_State;

	struct ActionCommand
	{
		int				m_Action;
		int				m_Command;
		std::string		m_Param;
		int				m_MouseXup;
		int				m_MouseYup;
		int				m_MouseXdown;
		int				m_MouseYdown;
	};
	std::vector<ActionCommand>			 m_VecActionCommand;
	std::vector<ActionCommand>::iterator m_ItVecActionCommand;
	
public:
	std::ostrstream *Consol;
	ExCInterface(void);
	ExCInterface(std::string FileName);
	~ExCInterface(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	bool LoadFile(std::string FileName);

	inline void SetManagerWindow(ExManagerWindow *Window){ManagerWindow = Window;}
	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture = Texture;}
	
	inline void SetNumInterface(int num){m_NumInterface=num;}
	inline int	GetNumInterface(void ){return m_NumInterface;}

	inline	void ShowRegion(void){m_ShowRegion=true;}
	inline	void HideRegion(void){m_ShowRegion=false;}
	inline	void DisableInterface(void){m_State=false;}
	inline	void EnableInterface(void){m_State=true;}
	inline  bool GetInterfaceState(void){return m_State;}

	void Draw(void);
	ExCAction InputCommand(int command,int mousex,int mousey);

};
//------------------------------------------------------------------------
#endif //__EXCINTERFACE_H__
