/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 
 *
 */

#include "ExCLoadingAnimation.h"

ExCLoadingAnimation::ExCLoadingAnimation(void)
{
	SetName("ExCLoadingAnimation");
	SetType(typeid(this).name());
	m_NumberAnimTexture=0;
	m_CurrentAnimationTexture=0;
}

ExCLoadingAnimation::~ExCLoadingAnimation(void)
{
}

void ExCLoadingAnimation::Draw(void)
{
Guard(void ExCLoadingAnimation::Draw(void))
	ExNihilo::EnterOrthoMode();
		//ManagerTexture->Add(m_VecAnimTexture.at(m_CurrentAnimationTexture));	
		if(m_CurrentAnimationTexture>=m_VecAnimTexture.size())m_CurrentAnimationTexture=m_VecAnimTexture.size()-1;
		ManagerTexture->SetCurrentObject(m_VecAnimTexture.at(m_CurrentAnimationTexture));	
		glEnable(GL_TEXTURE_2D);
		glDisable(GL_LIGHTING);
		glBegin(GL_QUADS);
		glColor3f(1.0f,1.0f,1.0f);
		glTexCoord2f(0,1);
		glVertex2f(0,0);
		glTexCoord2f(0,0);
		glVertex2f(0,ExNihilo::GetResolutionY());
		glTexCoord2f(1,0);
		glVertex2f(ExNihilo::GetResolutionX(),ExNihilo::GetResolutionY());
		glTexCoord2f(1,1);
		glVertex2f(ExNihilo::GetResolutionX(),0);
		glEnd();
	ExNihilo::LeaveOrthoMode();
UnGuard
}


void ExCLoadingAnimation::Load(std::string FileName)
{
Guard(void ExCLoadingAnimation::Load(std::string FileName))
	m_CurrentAnimationTexture=0;
	char			buffer[255];
	#ifdef UNIX_SRC
		sprintf(buffer, PREFIX "/ExNihilo/Data/Loading/%s", FileName.data());
	#else
		sprintf(buffer, "../Data/Loading/%s", FileName.data());
	#endif
		std::ifstream fin;
		std::string buffstring;
		char b[256];
		fin.open(buffer,std::ios::in);
		if(fin.is_open())
		{
			try
			{
				//----Read all file
				do
				{
					memset(b,0,255);
					fin.getline(b,256,'\n');
					try
					{
						m_NumberAnimTexture++;
						m_VecAnimTexture.push_back(ExNihilo::ExtracValueFromSring(b,"<Frame>","<#Frame>"));
					}catch(ExCExpStringNotFound){}
				}while(!fin.eof());
				fin.close();
			}catch(...){throw ExCExpFileReadError();}
		}else throw   ExCExpFileNotFound();

UnGuard
}

bool ExCLoadingAnimation::Next(void)
{
Guard(bool ExCLoadingAnimation::Next(void))
	if(m_CurrentAnimationTexture>=m_NumberAnimTexture)
	{
		m_CurrentAnimationTexture=0;return false;
	}else
	{
		m_CurrentAnimationTexture++;return true;
	}
UnGuard
}


bool ExCLoadingAnimation::Previous(void)
{
Guard(bool ExCLoadingAnimation::Previous(void))
	if(m_CurrentAnimationTexture<=0)
	{
		m_CurrentAnimationTexture=0;return false;
	}else
	{
		m_CurrentAnimationTexture--;return true;
	}
UnGuard
}

void ExCLoadingAnimation::Last(void)
{
Guard(void ExCLoadingAnimation::Last(void))
	m_CurrentAnimationTexture=m_NumberAnimTexture;
UnGuard
}

void ExCLoadingAnimation::First(void)
{
Guard(void ExCLoadingAnimation::First(void))
	m_CurrentAnimationTexture=0;
UnGuard
}
