/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCLoadingAnimation.h									*/
/*																		*/
/* Start Date  :07/17/2003												*/
/*																		*/
/* Last Update :07/17/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXCLOADINGANIMATION_H__
#define __EXCLOADINGANIMATION_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Object/Object2D/ExCObject2D.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerTexture.h"
//------------------------------------------------------------------------
class ExCLoadingAnimation : public ExCObject2D
{
private:
	int		m_CurrentAnimationTexture;
	int		m_NumberAnimTexture;
	std::vector<std::string> m_VecAnimTexture;
	
	ExManagerTexture			*ManagerTexture;

public:
	ExCLoadingAnimation(void);
	~ExCLoadingAnimation(void);
	
	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture=Texture;}
	
	void Draw(void);
	void Load(std::string FileName);
	bool Next(void);
	bool Previous(void);
	void First(void);
    void Last(void);
	inline int GetNumberAnimation(void){return m_NumberAnimTexture;}
};
//------------------------------------------------------------------------
#endif //__EXCLOADINGANIMATION_H__
