/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 *
 */

#include "ExCWindow.h"
//--------------------------------
// Constructor // Destructor
//--------------------------------
ExCWindow::ExCWindow(void)
{
Guard(ExCWindow::ExCWindow(void))
	Init();
UnGuard
}

ExCWindow::ExCWindow(ExCVec2D Size)
{
Guard(ExCWindow::ExCWindow(ExCVec2D Size))
	Init();
	SetWindowSize(Size);
	SetOldWindowSize(Size);
	RefreshSize();
	RefreshPosotion();
UnGuard
}

ExCWindow::ExCWindow(ExCVec2D Size,ExCVec2D Position)
{
Guard(ExCWindow::ExCWindow(ExCVec2D Size,ExCVec2D Position))
	Init();
	SetPosition(Position);
	SetOldPosition(Position);
	SetWindowSize(Size);
	SetOldWindowSize(Size);
	RefreshSize();
	RefreshPosotion();
UnGuard
}

ExCWindow::ExCWindow(ExCVec2D Size,ExCVec2D Position,std::string Title)
{
Guard(ExCWindow::ExCWindow(ExCVec2D Size,ExCVec2D Position,std::string Title))
	Init();
	SetWindowTitle(Title);
	SetPosition(Position);
	SetOldPosition(Position);
	SetWindowSize(Size);
	SetOldWindowSize(Size);
	RefreshSize();
	RefreshPosotion();

/*
	ExCWindowLabel *Label;
	Label = new ExCWindowLabel(ExCVec2D(100,22),ExCVec2D(10,10));
	m_Window.AddObjectControl(Label);

	
	ExCWindowEditLabel *EditLAbel;
	EditLAbel = new ExCWindowEditLabel(ExCVec2D(100,22),ExCVec2D(10,50));
	m_Window.AddObjectControl(EditLAbel);
*/

UnGuard
}

void ExCWindow::Init(void)
{
Guard(void ExCWindow::Init(void))
	ExCWindowObject::Init();
	SetName("ExCWindow");
	SetType(typeid(this).name());
	SetTitleBarSize(24);
	m_BeClosed=false;
	m_CloseButton= new ExCWindowButton;
	m_MaximizeButton= new ExCWindowButton;
	m_MinimizeButton= new ExCWindowButton;
	m_MinimizeToBarButton= new ExCWindowButton;
	//-----------------------------
	//Create Bar
	//-----------------------------
	m_TitleBar.SetName("BarWindow"+GetWindowTitle());
	m_TitleBar.ShowWindowTitle(true);
	m_TitleBar.SetWindowTitle(GetWindowTitle());
	m_TitleBar.SetWindowTitleColor(ExCVec3D(0.5f,0.0f,0.0f));
	m_TitleBar.SetBackroundTexturing1(true,"bar");
	m_TitleBar.SetBackroundTexturing2(true,"back3");
	m_TitleBar.SetTextureIsMouving(true);
	m_TitleBar.SetTextureMouvingVec(ExCVec2D(0.0001f,0.0f));
	m_TitleBar.SetBackroundColor(ExCVec3D(1.0f,1.0f,1.0f));
	m_TitleBar.SetCanMouve(true);
	m_TitleBar.SetBorderColor(ExCVec3D(0.5f,0.5f,0.5f));
	m_TitleBar.AddObjectControl(m_CloseButton);
	m_TitleBar.AddObjectControl(m_MaximizeButton);
	m_TitleBar.AddObjectControl(m_MinimizeButton);
	m_TitleBar.AddObjectControl(m_MinimizeToBarButton);
	//------------------------------
	m_CloseButton->SetName("CloseButton");
	m_CloseButton->SetBackroundTexturing1(true,"ButtClose.bmp");
	m_CloseButton->SetBackroundTexturing2(false,"NONE");
	m_CloseButton->SetBackroundColor(ExCVec3D(0.5f,0.5f,0.5f));
	m_CloseButton->AddActionCommand(ExCAction(CLOSE_OBJECT_WINDOW),ExCCommand(MOUSE_LEFT_BUTTON_DOWN));
	//------------------------------
	m_MaximizeButton->SetName("ButtMax");
	m_MaximizeButton->SetBackroundTexturing1(true,"ButtMax.bmp");
	m_MaximizeButton->SetBackroundTexturing2(false,"NONE");
	m_MaximizeButton->SetBackroundColor(ExCVec3D(0.5f,0.5f,0.5f));
	m_MaximizeButton->AddActionCommand(ExCAction(MAXIMIZE_OBJECT_WINDOW),ExCCommand(MOUSE_LEFT_BUTTON_DOWN));
	//------------------------------
	m_MinimizeButton->SetName("ButtMin");
	m_MinimizeButton->SetBackroundTexturing1(true,"ButtMin.bmp");
	m_MinimizeButton->SetBackroundTexturing2(false,"NONE");
	m_MinimizeButton->SetBackroundColor(ExCVec3D(0.5f,0.5f,0.5f));
	m_MinimizeButton->AddActionCommand(ExCAction(MINIMIZE_OBJECT_WINDOW),ExCCommand(MOUSE_LEFT_BUTTON_DOWN));
	//------------------------------
	m_MinimizeToBarButton->SetName("ButtBar");
	m_MinimizeToBarButton->SetBackroundTexturing1(true,"ButtBar.bmp");
	m_MinimizeToBarButton->SetBackroundTexturing2(false,"NONE");
	m_MinimizeToBarButton->SetBackroundColor(ExCVec3D(0.5f,0.5f,0.5f));
	m_MinimizeToBarButton->AddActionCommand(ExCAction(MINIMIZE_TO_BAR_OBJECT_WINDOW),ExCCommand(MOUSE_LEFT_BUTTON_DOWN));
	//------------------------------
	//Create window
	//------------------------------
	m_Window.SetName("MainWindow"+GetWindowTitle());
	m_Window.SetBackroundTexturing1(false,"back");
	m_Window.SetBackroundTexturing2(false,"fire");
	m_Window.SetBackroundColor(ExCVec3D(1.0f,1.0f,1.0f));
	m_Window.SetCanMouve(false);
	
UnGuard
}

ExCWindow::~ExCWindow(void)
{
}

//--------------------------------
// Methode
//--------------------------------
void ExCWindow::Draw(void)
{
Guard(void ExCWindow::Draw(void))
	//std::cout<<"Draw windows"<<std::endl;
	ExNihilo::EnterOrthoMode();
	glPushAttrib(GL_ALL_ATTRIB_BITS);
		glDisable(GL_LIGHTING);
		//Draw TitleBar
		m_TitleBar.Draw();
		//Draw Window
		//if(m_Window.IsShowWindow())
		m_Window.Draw();
	glPopAttrib();
	ExNihilo::LeaveOrthoMode();
UnGuard
}



ExCAction ExCWindow::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExCWindow::InputCommand(ExCCommand Command))
	//std::cout<<"ExCWindow::Input Command window:"<<Command.m_Command<<std::endl;
	/*switch(Command.m_Command)
	{
	default :*/
		if(m_TitleBar.PointInWindow(ExCVec2D(Command.m_MousePosx,Command.m_MousePosy)))
		{
			//std::cout<<"Dans la bar"<<std::endl;
			return InputAction(m_TitleBar.InputCommand(Command));
		}
		if(m_Window.PointInWindow(ExCVec2D(Command.m_MousePosx,Command.m_MousePosy)))
		{
			//std::cout<<"Dans la fenetre"<<std::endl;
			return InputAction(m_Window.InputCommand(Command));
		}
/*
		break;
	}*/
	
	return NOTHING;
UnGuard
}

ExCAction ExCWindow::InputAction(ExCAction Action)
{
Guard(ExCAction ExCWindow::InputAction(ExCAction Action))
	/*switch(Action.m_Action)
	{
	default:
		return Action;
	}
	if(Action.m_NextAction){return *Action.m_NextAction;}
	else{return NOTHING;}*/
	return Action;
UnGuard
}

void ExCWindow::SetManagerTexture(ExManagerTexture * Texture)
{
Guard(void ExCWindow::SetManagerTexture(ExManagerTexture * Texture))
	ManagerTexture = Texture;
	m_TitleBar.SetManagerTexture(ManagerTexture);
	m_Window.SetManagerTexture(ManagerTexture);
UnGuard
}

void ExCWindow::RefreshPosotion(void)
{
Guard(void ExCWindow::RefreshPosotion(void))
	//std::cout<<"Refresh pos"<<std::endl;
	m_TitleBar.SetPosition(ExCVec2D(m_Position.GetX(),m_Position.GetY()));
	m_Window.SetPosition(ExCVec2D(m_Position.GetX(),(m_Position.GetY()+m_TitleBarSize)));
	m_CloseButton->SetPosition(ExCVec2D(m_TitleBar.GetPosition().GetX()+m_WindowSize.GetX()-m_TitleBarSize,m_TitleBar.GetPosition().GetY()+2));
	m_MaximizeButton->SetPosition(ExCVec2D(m_TitleBar.GetPosition().GetX()+m_WindowSize.GetX()-m_TitleBarSize*2,m_TitleBar.GetPosition().GetY()+2));
	m_MinimizeButton->SetPosition(ExCVec2D(m_TitleBar.GetPosition().GetX()+m_WindowSize.GetX()-m_TitleBarSize*3,m_TitleBar.GetPosition().GetY()+2));
	m_MinimizeToBarButton->SetPosition(ExCVec2D(m_TitleBar.GetPosition().GetX()+m_WindowSize.GetX()-m_TitleBarSize*4,m_TitleBar.GetPosition().GetY()+2));
	for(unsigned int i=0;i<m_Window.GetVecWindowObject()->size();i++)
	{
		m_Window.GetVecWindowObject()->at(i)->SetPosition(
			ExCVec2D(m_Window.GetPosition()+(m_Window.GetVecWindowObject()->at(i)->GetPosition()-m_Window.GetOldPosition())));	
	}
UnGuard
}	
void ExCWindow::RefreshSize(void)
{
Guard(void ExCWindow::RefreshSize(void))
	m_TitleBar.SetWindowSize(ExCVec2D(m_WindowSize.GetX(),m_TitleBarSize));
	m_Window.SetWindowSize(ExCVec2D(m_WindowSize.GetX(),m_WindowSize.GetY()-m_TitleBarSize));
	m_CloseButton->SetWindowSize(ExCVec2D(m_TitleBarSize-3,m_TitleBarSize-4));
	m_MaximizeButton->SetWindowSize(ExCVec2D(m_TitleBarSize-3,m_TitleBarSize-4));
	m_MinimizeButton->SetWindowSize(ExCVec2D(m_TitleBarSize-3,m_TitleBarSize-4));
	m_MinimizeToBarButton->SetWindowSize(ExCVec2D(m_TitleBarSize-3,m_TitleBarSize-4));
UnGuard
}	

void ExCWindow::SetWindowSize(ExCVec2D vec)
{
Guard(void ExCWindow::SetWindowSize(ExCVec2D vec))
	m_WindowSize=vec;
	RefreshSize();
UnGuard
}
void ExCWindow::SetOldWindowSize(ExCVec2D vec)
{
Guard(void ExCWindow::SetOldWindowSize(ExCVec2D vec))
	m_OldSize=vec;
UnGuard
}

void ExCWindow::SetWindowPosition(ExCVec2D vec)
{
Guard(void ExCWindow::SetWindowPosition(ExCVec2D vec))
	SetOldPosition(GetPosition());
	SetPosition(vec);
	RefreshPosotion();
	RefreshSize();

UnGuard
}

void ExCWindow::SetOldPosition(ExCVec2D vec)
{
Guard(void ExCWindow::SetOldPosition(ExCVec2D vec))
	m_OldPosition=vec;
UnGuard
}
void ExCWindow::SetTitleBarSize(float size)
{
Guard(void ExCWindow::SetTitleBarSize(float size))
	m_TitleBarSize=size;
	m_TitleBar.SetWindowSize(ExCVec2D(m_WindowSize.GetX(),m_TitleBarSize));
UnGuard
}	

void ExCWindow::SetWindowTitle(std::string Title)
{
	m_WindowTitle=Title;
	m_TitleBar.SetWindowTitle(Title);
}
std::string  ExCWindow::GetWindowTitle(void)
{
	return m_TitleBar.GetWindowTitle();
}
void ExCWindow::SetWindowOldTitle(std::string Title)
{
	m_WindowOldTitle=Title;
	m_TitleBar.SetWindowOldTitle(Title);
}
std::string  ExCWindow::GetWindowOldTitle(void)
{
	return m_TitleBar.GetWindowOldTitle();
}
void ExCWindow::SetWindowTitleColor(ExCVec3D Color)
{
	m_WindowTitleColor=Color;
	m_TitleBar.SetWindowTitleColor(Color);
}	
ExCVec3D ExCWindow::GetWindowTitleColor(void)
{
	return m_TitleBar.GetWindowTitleColor();
}

bool ExCWindow::PointInWindow(ExCVec2D point)
{
	if(ExCWindowObject::PointInWindow(point))
	{
		if(m_TitleBar.PointInWindow(point))return true;
		if(m_Window.PointInWindow(point))
		{
			if(m_Window.IsShowWindow())return true;
			else return false;
		}
		
	}
	return false;
	
}