/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/* Benjamin Michotte Linux port, webmaster                              */
/*                                                                      */
/* Mail             :binny@ploksoftware.org                             */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCWindow.h												*/
/*																		*/
/* Star Date   :03/14/2003												*/
/*																		*/
/* Last Update :                                                        */

/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXCWINDOW_H__
#define __EXCWINDOW_H__
//--------------------------------
// File to include
//--------------------------------
#include "ExDefine.h"
#include "Math/ExMath.h"
#include "Manager/ManagerObject/ExManagerTexture.h"
#include "Manager/ExManagerWindow.h"
//--------------------------------
#include "Object/Object2D/WindowObject/ExCWindowObject.h"
#include "Object/Object2D/WindowObject/ExCWindowControl.h"
#include "Object/Object2D/WindowObject/ExCWindowButton.h"
#include "Object/Object2D/WindowObject/ExCWindowLabel.h"
#include "Object/Object2D/WindowObject/ExCWindowEditLabel.h"
//--------------------------------
class ExCWindow :public ExCWindowObject
{
//--------------------------------
// Variable
//--------------------------------
protected:
	//Title Bar
	ExCWindowObject		m_TitleBar;
	ExCWindowButton		*m_CloseButton;
	ExCWindowButton		*m_MaximizeButton;
	ExCWindowButton		*m_MinimizeButton;
	ExCWindowButton		*m_MinimizeToBarButton;
	//Window content
	ExCWindowObject		m_Window;


	void Init(void);
public:
	
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExCWindow(void);
	ExCWindow(ExCVec2D Size);
	//inline ExCWindow(float x,float y){ExCWindow(ExCVec2D(x,y));};
	ExCWindow(ExCVec2D Size,ExCVec2D Position);
	/*inline ExCWindow(float x,float y,float xp,float yp)
		{ExCWindow(ExCVec2D(x,y),ExCVec2D(xp,yp));};*/
	ExCWindow(ExCVec2D Size,ExCVec2D Position,std::string Title);
	/*inline ExCWindow(float x,float y,float xp,float yp,std::string Title)
		{ExCWindow(ExCVec2D(x,y),ExCVec2D(xp,yp),Title);}*/
	~ExCWindow(void);
//--------------------------------
// Methode
//--------------------------------
	void RefreshPosotion(void);
	void RefreshSize(void);
	bool	m_BeClosed;
	void SetManagerTexture(ExManagerTexture * Texture);
	void Draw(void);
	virtual ExCAction InputAction(ExCAction Action);
	virtual ExCAction InputCommand(ExCCommand Command);
	//GetPointer
	ExCWindowObject *GetWindowContentPointer(void){return &m_Window;}
	ExCWindowObject *GetWindowBarPointer(void){return &m_TitleBar;}
	ExCWindowButton *GetButtonClose(void){return m_CloseButton;}
	ExCWindowButton *GetButtonMaximize(void){return m_MaximizeButton;}
	ExCWindowButton *GetButtonMinimize(void){return m_MinimizeButton;}
	ExCWindowButton *GetButtonMinimizeToBar(void){return m_MinimizeToBarButton;}

	//Position and size
	void SetWindowSize(ExCVec2D vec);//{m_WindowSize=vec;}
	//inline ExCVec2D GetWindowSize(void){return m_WindowSize;}
	void SetOldWindowSize(ExCVec2D vec);//{m_OldSize=vec;}
	//inline ExCVec2D GetOldWindowSize(void){return m_OldSize;}
	void SetOldPosition(ExCVec2D vec);//{m_OldPosition=vec;}
	//inline ExCVec2D GetOldPosition(void){return m_OldPosition;}
	void SetTitleBarSize(float size);//{m_TitleBarSize=size;}
	//inline float GetTitleBarSize(void){return m_TitleBarSize;}
	void SetWindowPosition(ExCVec2D vec);
	inline bool IsShowWindowContent(void){return m_Window.IsShowWindow();}
	inline void	SetShowWindowContent(bool status){m_Window.SetShowWindow(status);}
	inline bool IsShowWindowBar(void){return m_TitleBar.IsShowWindow();}
	inline void	SetShowWindowBar(bool status){m_TitleBar.SetShowWindow(status);}
	//Title
	void SetWindowTitle(std::string Title);
	std::string GetWindowTitle(void);
	void SetWindowOldTitle(std::string Title);
	std::string GetWindowOldTitle(void);
	void	SetWindowTitleColor(ExCVec3D Color);
	ExCVec3D GetWindowTitleColor(void);

	bool PointInWindow(ExCVec2D point);
};
#endif //__EXCWINDOW_H__
