/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 *
 */

#include "ExCWindowButtonSwitch.h"
//--------------------------------
// Constructor // Destructor
//--------------------------------
ExCWindowButtonSwitch::ExCWindowButtonSwitch(void)
{
Guard(ExCWindowButtonSwitch::ExCWindowButtonSwitch(void))
	Init();
UnGuard
}

ExCWindowButtonSwitch::ExCWindowButtonSwitch(ExCVec2D Size,ExCVec2D Position)
{
Guard(ExCWindowButtonSwitch::ExCWindowButtonSwitch(ExCVec2D Size,ExCVec2D Position))
	Init();
	SetPosition(Position);
	SetOldPosition(Position);
	SetWindowSize(Size);
	SetOldWindowSize(Size);
UnGuard
}

ExCWindowButtonSwitch::~ExCWindowButtonSwitch(void)
{
}
//--------------------------------
// Methode
//--------------------------------
void ExCWindowButtonSwitch::Init(void)
{
Guard(void ExCWindowButtonSwitch::Init(void))
	ExCWindowObject::Init();
	SetName("ExCWindowButtonSwitch");
	SetType(typeid(this).name());
	ShowWindowTitle(true);
	m_StateButton=true;
UnGuard
}

void ExCWindowButtonSwitch::Draw(void)
{
Guard(void ExCWindowButtonSwitch::Draw(void))
	ExCWindowObject::Draw();
UnGuard
}

ExCAction ExCWindowButtonSwitch::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExCWindowButtonSwitch::InputCommand(ExCCommand Command))
	//std::cout<<"ExCWindowButtonSwitch::Input Command window:"<<Command.m_Command<<std::endl;
	for(unsigned int i=0;i<m_VecCommandAction.size();i++)
	{
		if(m_VecCommandAction.at(i).first.m_Command==Command.m_Command)
		{
			SwitchValue();
			return m_VecCommandAction.at(i).second;
		}
	}
	return NOTHING;
UnGuard
}

ExCAction ExCWindowButtonSwitch::InputAction(ExCAction Action)
{
Guard(ExCAction ExCWindowButtonSwitch::InputAction(ExCAction Action))
	return NOTHING;
UnGuard
}

void ExCWindowButtonSwitch::SwitchValue(void)
{
Guard(void ExCWindowButtonSwitch::SwitchValue(void))
	ExCWindowButton *ValueSource;
	if (m_StateButton)
	{
		ValueSource=m_Butt1;
		m_StateButton=false;
	}else
	{
		ValueSource=m_Butt2;
		m_StateButton=true;
	}
	//Title
	m_ShowWindowTitle=ValueSource->IsShowWindowTitle();
	m_WindowTitle=ValueSource->GetWindowTitle();
	m_WindowOldTitle=ValueSource->GetWindowOldTitle();
	m_WindowTitleColor=ValueSource->GetWindowTitleColor();
	//Color and blending
	m_Blending=ValueSource->IsBackroundBlending();
	m_BackroundBlending=ValueSource->GetBackroundBlending();
	m_BackroundColor=ValueSource->GetBackroundColor();
	//Border 
	m_BorderColor=ValueSource->GetBorderColor();
	m_BorderSize=ValueSource->GetBorderSize();
	m_ShowBorder=ValueSource->GetShowBorder();
	//Texturing
	m_BackroundIsTexturing1=ValueSource->IsBackroundTexturing1();
	m_BackroundTexture1=ValueSource->GetBackroundTexture1();
	m_BackroundIsTexturing2=ValueSource->IsBackroundTexturing2();
	m_BackroundTexture2=ValueSource->GetBackroundTexture2();
	m_TextureIsMouving=ValueSource->IsTextureIsMouving();
	m_TextureMouvingVec=ValueSource->GetTextureMouvingVec();

	m_VecCommandAction=ValueSource->GetVecActionCommand();
UnGuard
}