/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 *
 */

#include "ExCWindowContent.h"
//--------------------------------
// Constructor // Destructor
//--------------------------------
ExCWindowContent::ExCWindowContent(void)
{
Guard(ExCWindowContent::ExCWindowContent(void))
	SetName("ExCWindowContent");
	SetType(typeid(this).name());
UnGuard
}

ExCWindowContent::~ExCWindowContent(void)
{
}
//--------------------------------
// Methode
//--------------------------------
void ExCWindowContent::Draw(void)
{
Guard(void ExCWindowContent::Draw(void))
	//------------------------------
	//Draw all Child
	//------------------------------
	for(unsigned int i=0;i<m_VecWindowObject.size();i++)
	{
		//m_VecWindowObject.at(i).SetParrent(this);	
		glPushMatrix();
		m_VecWindowObject.at(i)->Draw();	
		glPopMatrix();
	}
UnGuard
}

void ExCWindowContent::AddObject(ExCWindowObject *object)
{
Guard(void ExCWindowContent::AddObject(ExCWindowObject *object))
	m_VecWindowObject.push_back(object);
UnGuard
}

void ExCWindowContent::SetManagerTexture(ExManagerTexture * Texture)
{
Guard(void ExCWindowContent::SetManagerTexture(ExManagerTexture * Texture))
	ManagerTexture=Texture;
	for(unsigned int i=0;i<m_VecWindowObject.size();i++)
	{
		m_VecWindowObject.at(i)->SetManagerTexture(Texture);	
	}
UnGuard
}

ExCAction ExCWindowContent::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExCWindowContent::InputCommand(ExCCommand Command))
	//Transform mouse position 
	Command.m_MousePosx-=GetPosition().GetX();
	Command.m_MousePosy-=GetPosition().GetY();
	//Check where mouse has been pressed and route command to control
	for(unsigned int i=0;i<m_VecWindowObject.size();i++)
	{
		if(m_VecWindowObject.at(i)->PointInWindow(ExCVec2D (Command.m_MousePosx,Command.m_MousePosy)))
		{
			return m_VecWindowObject.at(i)->InputCommand(Command);
		}
	}
	return NOTHING;
UnGuard
}

ExCAction ExCWindowContent::InputAction(ExCAction Action)
{
Guard(ExCAction ExCWindowContent::InputAction(ExCAction Action))
	return Action;
UnGuard
}