/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 *
 */

#include "ExCWindowEditLabel.h"
//--------------------------------
// Constructor // Destructor
//--------------------------------
ExCWindowEditLabel::ExCWindowEditLabel(void)
{
Guard(ExCWindowEditLabel::ExCWindowEditLabel(void))
	Init();
UnGuard
}

ExCWindowEditLabel::ExCWindowEditLabel(ExCVec2D Size,ExCVec2D Position)
{
Guard(ExCWindowEditLabel::ExCWindowEditLabel(ExCVec2D Size,ExCVec2D Position))
	Init();
	SetPosition(Position);
	SetOldPosition(Position);
	SetWindowSize(Size);
	SetOldWindowSize(Size);
UnGuard
}

ExCWindowEditLabel::~ExCWindowEditLabel(void)
{
}
//--------------------------------
// Methode
//--------------------------------
void ExCWindowEditLabel::Init(void)
{
Guard(void ExCWindowEditLabel::Init(void))
	ExCWindowLabel::Init();
	SetName("ExCWindowLabel");
	SetType(typeid(this).name());
	SetWindowTitle("Edit Label");
	m_GetText=false;
UnGuard
}
void ExCWindowEditLabel::Draw(void)
{
//Guard(void ExCWindowEditLabel::Draw(void))
	int time=0.01*glutGet(GLUT_ELAPSED_TIME);
	//std::cout<<"Time:"<<time<<std::endl;
	if((time%4)==0&&m_GetText)
	{
		m_WindowTitle=m_WindowTitle+"|";	
	}
	ExCWindowObject::Draw();
	if((time%4)==0&&m_GetText)
	{
		m_WindowTitle.resize(m_WindowTitle.size()-1);
	}
//UnGuard
}

ExCAction ExCWindowEditLabel::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExCWindowEditLabel::InputCommand(ExCCommand Command))
	std::cout<<"ExCWindowEditLabel::Input Command window:"<<Command.m_Command<<std::endl;
	if(m_GetText)
	{
		std::string bufferstring;
		ExNihilo::AddKeyToBuffer(Command.m_Command,bufferstring);
		m_WindowTitle=m_WindowTitle+bufferstring;
		std::cout<<"Add:"<<bufferstring<<std::endl;
	}
	switch(Command.m_Command) 
	{
	case KEYBOARD_DOWN_BACKSPACE:
		if(m_WindowTitle.size()>0)
		{
			m_WindowTitle.resize(m_WindowTitle.size()-1);
		}
		break;
	case KEYBOARD_DOWN_ENTER:
		m_GetText=false;
		//return RELEASE_FOCUS_OBJECT_WINDOW;
		break;
	case MOUSE_LEFT_BUTTON_DOWN:
		m_GetText=true;
		//return REQUEST_FOCUS_OBJECT_WINDOW;
		//request focus until enter is pressed
		break;
/*	case WINDOW_LOSE_FOCUS:
		std::cout<<"Lose focus"<<std::endl;
		m_GetText=false;
	case WINDOW_GET_FOCUS:
		std::cout<<"Get focus"<<std::endl;
		m_GetText=true;*/
	}

	for(unsigned int i=0;i<m_VecCommandAction.size();i++)
	{
		if(m_VecCommandAction.at(i).first.m_Command==Command.m_Command)
		{
			return InputAction(m_VecCommandAction.at(i).second);
		}
	}

	return NOTHING;
UnGuard
}

ExCAction ExCWindowEditLabel::InputAction(ExCAction Action)
{
Guard(ExCAction ExCWindowEditLabel::InputAction(ExCAction Action))
	switch(Action.m_Action) 
	{
	/*case CUSTOM_ACTION_2:
		
		break;
	case CUSTOM_ACTION_3:
		m_GetText=true;
		break;
	case CUSTOM_ACTION_4:
		m_GetText=false;
		break;*/
	default :
		return Action;
	}	
	return NOTHING;
UnGuard
}
