/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 *
 */

#include "ExCWindowMessageBox.h"
//--------------------------------
// Constructor // Destructor
//--------------------------------
ExCWindowMessageBox::ExCWindowMessageBox(void)
{
Guard(ExCWindowMessageBox::ExCWindowMessageBox(void))
	Init();
UnGuard
}

ExCWindowMessageBox::ExCWindowMessageBox(std::string Message)
{
Guard(ExCWindowMessageBox::ExCWindowMessageBox(std::string Message))
	Init();
	m_Message=Message;
	RefreshSize();
	RefreshPosotion();
UnGuard
}

void ExCWindowMessageBox::Init(void)
{
Guard(void ExCWindowMessageBox::Init(void))
	ExCWindow::Init();
	SetName("ExCWindow");
	SetType(typeid(this).name());
	SetPosition(ExCVec2D(ExNihilo::GetResolutionX()/2-150,(ExNihilo::GetResolutionY()/2)-50));
	SetOldPosition(ExCVec2D(ExNihilo::GetResolutionX()/2-150,(ExNihilo::GetResolutionY()/2)-50));
	SetWindowSize(ExCVec2D(300,100));
	SetOldWindowSize(ExCVec2D(300,100));
	m_Window.SetBackroundColor(ExCVec3D(0.5f,0.5f,0.5f));
	m_Window.SetBorderColor(ExCVec3D(0.2f,0.2f,0.2f));
	m_OkButton = new ExCWindowButton;
	m_OkButton->SetWindowSize(ExCVec2D(50,20));
	m_OkButton->SetPosition(ExCVec2D(125,50));
	m_OkButton->SetWindowTitle("   OK   ");
	m_OkButton->ShowWindowTitle(true);
	m_OkButton->AddActionCommand(ExCAction(CLOSE_OBJECT_WINDOW),ExCCommand(MOUSE_LEFT_BUTTON_DOWN));
	m_Window.AddObjectControl(m_OkButton);
UnGuard
}

ExCWindowMessageBox::~ExCWindowMessageBox(void)
{
}

//--------------------------------
// Methode
//--------------------------------
void ExCWindowMessageBox::Draw(void)
{
Guard(void ExCWindowMessageBox::Draw(void))
	//std::cout<<"Draw ExCWindowMessageBox"<<std::endl;
	ExNihilo::EnterOrthoMode();
	glPushAttrib(GL_ALL_ATTRIB_BITS);
		glDisable(GL_LIGHTING);
		m_Window.Draw();
		glColor3f(0.0f,0.0f,0.0f);
		ExNihilo::WriteToScreen(m_Position.GetX()+5,m_Position.GetY()+5+m_WindowSize.GetY()/2,m_Message);
	glPopAttrib();
	ExNihilo::LeaveOrthoMode();
UnGuard
}



ExCAction ExCWindowMessageBox::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExCWindowMessageBox::InputCommand(ExCCommand Command))
	//std::cout<<"ExCWindow::Input Command window:"<<Command.m_Command<<std::endl;
	switch(Command.m_Command)
	{
	case KEYBOARD_DOWN_ENTER:
		return CLOSE_OBJECT_WINDOW;
	default :
		if(m_TitleBar.PointInWindow(ExCVec2D(Command.m_MousePosx,Command.m_MousePosy)))
		{
			//std::cout<<"Dans la bar"<<std::endl;
			return InputAction(m_TitleBar.InputCommand(Command));
		}
		if(m_Window.PointInWindow(ExCVec2D(Command.m_MousePosx,Command.m_MousePosy)))
		{
			//std::cout<<"Dans la fenetre"<<std::endl;
			return InputAction(m_Window.InputCommand(Command));
		}

		break;
	}
	
	return NOTHING;
UnGuard
}

ExCAction ExCWindowMessageBox::InputAction(ExCAction Action)
{
Guard(ExCAction ExCWindowMessageBox::InputAction(ExCAction Action))
	/*switch(Action.m_Action)
	{
	default:
		return Action;
	}
	if(Action.m_NextAction){return *Action.m_NextAction;}
	else{return NOTHING;}*/
	return Action;
UnGuard
}


