/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 *
 */

#include "ExCWindowTitleBar.h"
//--------------------------------
// Constructor // Destructor
//--------------------------------
ExCWindowTitleBar::ExCWindowTitleBar(ExCWindowObject *Parent,ExManagerTexture *Texture,ExCVec2D Size)
{
Guard(ExCWindowTitleBar::ExCWindowTitleBar(ExCWindowObject *Parent,ExManagerTexture *Texture,ExCVec2D Size);)
	ExCWindowObject::Init();	
	SetName("ExCWindowTitleBar");
	SetType(typeid(this).name());
	m_HasCloseButton=true;
	m_HasMaximizeButton=true;
	m_HasMinimizeButton=true;
	m_HasMinimizeToBarButton=true;
	Init();
	SetWindowSize(Size);
	ExCWindowContent::SetManagerTexture(Texture);
	ExCWindowObject::SetParrent(Parent);
UnGuard
}


ExCWindowTitleBar::~ExCWindowTitleBar(void)
{
}
//--------------------------------
// Methode
//--------------------------------
void ExCWindowTitleBar::Init(void)
{
Guard(void ExCWindowTitleBar::Init(void))
	//-----------------------------
	//Create Bar
	//-----------------------------
	SetName("BarWindow");
	SetBackroundTexturing1(true,"bar");
	SetBackroundTexturing2(true,"back3");
	SetTextureIsMouving(true);
	SetTextureMouvingVec(ExCVec2D(0.0001f,0.0f));
	SetBackroundColor(ExCVec3D(1.0f,1.0f,1.0f));
	SetBorderColor(ExCVec3D(0.5f,0.5f,0.5f));
	//------------------------------

	//------------------------------
	m_CloseButton = new ExCWindowButton;
	m_CloseButton->SetName("CloseButton");
	m_CloseButton->SetBackroundTexturing1(true,"ButtClose.bmp");
	m_CloseButton->SetBackroundTexturing2(false,"NONE");
	m_CloseButton->SetBackroundColor(ExCVec3D(0.5f,0.5f,0.5f));
	m_CloseButton->AddActionCommand(ExCAction(CLOSE_OBJECT_WINDOW),ExCCommand(MOUSE_LEFT_BUTTON_DOWN));
	AddObject(m_CloseButton);
	//------------------------------
	m_MaximizeButton = new ExCWindowButton;
	m_MaximizeButton->SetName("ButtMax");
	m_MaximizeButton->SetBackroundTexturing1(true,"ButtMax.bmp");
	m_MaximizeButton->SetBackroundTexturing2(false,"NONE");
	m_MaximizeButton->SetBackroundColor(ExCVec3D(0.5f,0.5f,0.5f));
	m_MaximizeButton->AddActionCommand(ExCAction(MAXIMIZE_OBJECT_WINDOW),ExCCommand(MOUSE_LEFT_BUTTON_DOWN));
	AddObject(m_MaximizeButton);
	//------------------------------
	m_MinimizeButton = new ExCWindowButton;
	m_MinimizeButton->SetName("ButtMin");
	m_MinimizeButton->SetBackroundTexturing1(true,"ButtMin.bmp");
	m_MinimizeButton->SetBackroundTexturing2(false,"NONE");
	m_MinimizeButton->SetBackroundColor(ExCVec3D(0.5f,0.5f,0.5f));
	m_MinimizeButton->AddActionCommand(ExCAction(MINIMIZE_OBJECT_WINDOW),ExCCommand(MOUSE_LEFT_BUTTON_DOWN));
	AddObject(m_MinimizeButton);
	//------------------------------
	m_MinimizeToBarButton = new ExCWindowButton;
	m_MinimizeToBarButton->SetName("ButtBar");
	m_MinimizeToBarButton->SetBackroundTexturing1(true,"ButtBar.bmp");
	m_MinimizeToBarButton->SetBackroundTexturing2(false,"NONE");
	m_MinimizeToBarButton->SetBackroundColor(ExCVec3D(0.5f,0.5f,0.5f));
	m_MinimizeToBarButton->AddActionCommand(ExCAction(MINIMIZE_TO_BAR_OBJECT_WINDOW),ExCCommand(MOUSE_LEFT_BUTTON_DOWN));
	AddObject(m_MinimizeToBarButton);



UnGuard
}

void ExCWindowTitleBar::SetWindowSize(ExCVec2D Size)
{
Guard(void ExCWindowTitleBar::SetWindowSize(ExCVec2D Size))
	//ExCWindowObject::SetOldWindowSize(GetWindowSize());	
	ExCWindowObject::SetWindowSize(Size);	
	
	float buttonsize=GetWindowSize().GetY()-4;
	m_CloseButton->SetWindowSize(ExCVec2D(buttonsize,buttonsize));
	m_CloseButton->SetPosition(ExCVec2D(GetWindowSize().GetX()-buttonsize,1));
	m_MaximizeButton->SetWindowSize(ExCVec2D(buttonsize,buttonsize));
	m_MaximizeButton->SetPosition(ExCVec2D(GetWindowSize().GetX()-(buttonsize)*2-4,1));
	m_MinimizeButton->SetWindowSize(ExCVec2D(buttonsize,buttonsize));
	m_MinimizeButton->SetPosition(ExCVec2D(GetWindowSize().GetX()-(buttonsize)*3-8,1));
	m_MinimizeToBarButton->SetWindowSize(ExCVec2D(buttonsize,buttonsize));
	m_MinimizeToBarButton->SetPosition(ExCVec2D(GetWindowSize().GetX()-(buttonsize)*4-12,1));
UnGuard
}


void ExCWindowTitleBar::Draw(void)
{
Guard(void ExCWindowTitleBar::Draw(void))
	ExCWindowObject::Draw();
	ExCWindowContent::Draw();
UnGuard
}

ExCAction ExCWindowTitleBar::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExCWindowTitleBar::InputCommand(ExCCommand Command))
//std::cout<<"Bar"<<std::endl;
	return InputAction(ExCWindowContent::InputCommand(Command));
UnGuard
}

ExCAction ExCWindowTitleBar::InputAction(ExCAction Action)
{
Guard(ExCAction ExCWindowTitleBar::InputAction(ExCAction Action))
	return ExCWindowContent::InputAction(Action);
UnGuard
}

bool ExCWindowTitleBar::LoadFile(std::string FileName)
{
Guard(void ExCWindowTitleBar::LoadFile(std::string FileName))
	/*char			buffer[255],b[255];
	std::string buffstring;
	std::ifstream file,fileButton,fileControl;
	#ifdef UNIX_SRC
	sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", FileName.data());
	#else
	sprintf(buffer, "../Data/Window/%s", FileName.data());
	#endif
	std::cout<<buffer<<std::endl;
	file.open(buffer,std::ios::in);
	if(file.is_open())
	{
		memset(b,0,255);file.getline(b,256,'\n');
		try
		{
			buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
			Load(&file);
			//READ CLOSE BUTTON
			memset(b,0,255);file.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<FileForButtonClose>","<#FileForButtonClose>");
			#ifdef UNIX_SRC
			sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", buffstring.data());
			#else
			sprintf(buffer, "../Data/Window/%s", buffstring.data());
			#endif
			fileButton.open(buffer,std::ios::in);
			if(fileButton.is_open())
			{
				memset(b,0,255);fileButton.getline(b,256,'\n');
				buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
				m_CloseButton->Load(&fileButton);
				m_CloseButton->SetBackroundColor(ExCVec3D(1.0f,1.0f,1.0f));
			}fileButton.close();
			//READ Maximize BUTTON
			memset(b,0,255);file.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<FileForButtonMaximize>","<#FileForButtonMaximize>");
#ifdef UNIX_SRC
			sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", buffstring.data());
#else
			sprintf(buffer, "../Data/Window/%s", buffstring.data());
#endif
			fileButton.open(buffer,std::ios::in);
			if(fileButton.is_open())
			{
				memset(b,0,255);fileButton.getline(b,256,'\n');
				buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
				m_MaximizeButton->Load(&fileButton);
				m_MaximizeButton->SetBackroundColor(ExCVec3D(1.0f,1.0f,1.0f));
			}fileButton.close();
			//READ Minimize BUTTON
			memset(b,0,255);file.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<FileForButtonMinimize>","<#FileForButtonMinimize>");
#ifdef UNIX_SRC
			sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", buffstring.data());
#else
			sprintf(buffer, "../Data/Window/%s", buffstring.data());
#endif
			fileButton.open(buffer,std::ios::in);
			if(fileButton.is_open())
			{
				memset(b,0,255);fileButton.getline(b,256,'\n');
				buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
				m_MinimizeButton->Load(&fileButton);
				m_MinimizeButton->SetBackroundColor(ExCVec3D(1.0f,1.0f,1.0f));
			}fileButton.close();
			//READ MinimizeToBar BUTTON
			memset(b,0,255);file.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<FileForButtonMinimizeToBar>","<#FileForButtonMinimizeToBar>");
#ifdef UNIX_SRC
			sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", buffstring.data());
#else
			sprintf(buffer, "../Data/Window/%s", buffstring.data());
#endif
			fileButton.open(buffer,std::ios::in);
			if(fileButton.is_open())
			{
				memset(b,0,255);fileButton.getline(b,256,'\n');
				buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
				//ReadWindowObject(win->GetButtonMinimizeToBar(),&fileButton);
				m_MinimizeToBarButton->Load(&fileButton);
				m_MinimizeToBarButton->SetBackroundColor(ExCVec3D(1.0f,1.0f,1.0f));
			}fileButton.close();

			
		}catch(ExCExpStringNotFound)
		{
			std::cout<<"ReadWindowSubObject::ExCExpStringNotFound";
		}
	}else throw   ExCExpFileNotFound();
	file.close();
		*/
		return true;
UnGuard
}