/************************************************************************/
/* ExNihilo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCWindowTitleBar.h										*/
/*																		*/
/* Star Date   :03/16/2003												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :ABSTRACT CLASS										*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXCWINDOWTITLEBAR_H__
#define __EXCWINDOWTITLEBAR_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Object/Object2D/WindowObject/ExCWindowObject.h"
#include "Object/Object2D/WindowObject/ExCWindowButton.h"
#include "Object/Object2D/WindowObject/ExCWindowContent.h"
//------------------------------------------------------------------------
class ExCWindowTitleBar :public ExCWindowContent
{
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
public:
	ExCWindowButton		*m_CloseButton;
	ExCWindowButton		*m_MaximizeButton;
	ExCWindowButton		*m_MinimizeButton;
	ExCWindowButton		*m_MinimizeToBarButton;

	bool				m_HasCloseButton;
	bool				m_HasMaximizeButton;
	bool				m_HasMinimizeButton;
	bool				m_HasMinimizeToBarButton;
//------------------------------------------------------------------------
// Constructor // Destructor
//------------------------------------------------------------------------
	inline ExCWindowTitleBar(void){};//Never used
	ExCWindowTitleBar(ExCWindowObject *Parent,ExManagerTexture *Texture,ExCVec2D Size);
	~ExCWindowTitleBar(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	void Draw(void);
	void Init(void);
	ExCAction InputAction(ExCAction Action);
	ExCAction InputCommand(ExCCommand Command);
	bool LoadFile(std::string FileName);
	void SetWindowSize(ExCVec2D Size);

	inline void SetCloseButtonState(bool state){m_HasCloseButton=state;}
	inline void SetMaximizeButtonState(bool state){m_HasMaximizeButton=state;}
	inline void SetMinimizeButtonState(bool state){m_HasMinimizeButton=state;}
	inline void SetMinimizeToBarButtonState(bool state){m_HasMinimizeToBarButton=state;}
};
//------------------------------------------------------------------------
#endif //__EXCWINDOWTITLEBAR_H__
