/************************************************************************/
/* ExNihilo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCWindow.h												*/
/*																		*/
/* Star Date   :03/14/2003												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXCWINDOW_H__
#define __EXCWINDOW_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Manager/ExManagerWindow.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerTexture.h"
//------------------------------------------------------------------------
#include "Object/Object2D/WindowObject/ExCWindowObject.h"
#include "Object/Object2D/WindowObject/ExCWindowControl.h"
#include "Object/Object2D/WindowObject/ExCWindowButton.h"
#include "Object/Object2D/WindowObject/ExCWindowButtonSwitch.h"
#include "Object/Object2D/WindowObject/ExCWindowButtonSwitchOnMouse.h"
#include "Object/Object2D/WindowObject/ExCWindowLabel.h"
#include "Object/Object2D/WindowObject/ExCWindowEditLabel.h"
#include "Object/Object2D/WindowObject/ExCWindowTitleBar.h"
#include "Object/Object2D/WindowObject/ExCWindowContent.h"
//------------------------------------------------------------------------
class ExCWindow :public ExCWindowContent
{
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
protected:
	//Title Bar
	ExCWindowTitleBar		m_TitleBar;
	//Window content
	ExCWindowObject		m_Window;

	//Window state
	bool		m_CanMouve;
	bool		m_Mouving;
	bool		m_Reduced;
	bool		m_Maximized;
	bool		m_ShowWindow;
	bool		m_Active;			//if windows is the active windows

	bool		m_RequestFocus;


	void Init(void);
public:

//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExCWindow(void);
	ExCWindow(ExCVec2D Size);
	//inline ExCWindow(float x,float y){ExCWindow(ExCVec2D(x,y));};
	ExCWindow(ExCVec2D Size,ExCVec2D Position);
	/*inline ExCWindow(float x,float y,float xp,float yp)
		{ExCWindow(ExCVec2D(x,y),ExCVec2D(xp,yp));};*/
	ExCWindow(ExCVec2D Size,ExCVec2D Position,std::string Title);
	/*inline ExCWindow(float x,float y,float xp,float yp,std::string Title)
		{ExCWindow(ExCVec2D(x,y),ExCVec2D(xp,yp),Title);}*/
	~ExCWindow(void);
//--------------------------------
// Methode
//--------------------------------
	//State	
	inline bool IsMouving(void){return m_Mouving;}
	inline void	SetMouving(bool status){m_Mouving=status;}
	inline bool GetCanMouve(void){return m_CanMouve;}
	inline void	SetCanMouve(bool status){m_CanMouve=status;}
	inline bool IsReduced(void){return m_Reduced;}
	inline void	SetMaximized(bool status){m_Maximized=status;}
	inline bool IsMaximized(void){return m_Maximized;}
	inline void	SetReduced(bool status){m_Reduced=status;}
	inline bool IsShowWindow(void){return m_ShowWindow;}
	inline void	SetShowWindow(bool status){m_ShowWindow=status;}
	inline bool IsActive(void){return m_Active;}
	inline void	SetActive(bool status){m_Active=status;}

	void RefreshPosotion(void);
	void RefreshSize(void);
	bool	m_BeClosed;
	void SetManagerTexture(ExManagerTexture * Texture);
	void Draw(void);
	virtual ExCAction InputAction(ExCAction Action);
	virtual ExCAction InputCommand(ExCCommand Command);
	//GetPointer
	ExCWindowObject *GetWindowContentPointer(void){return &m_Window;}
	ExCWindowObject *GetWindowBarPointer(void){return &m_TitleBar;}
	ExCWindowButton *GetButtonClose(void){return m_CloseButton;}
	ExCWindowButton *GetButtonMaximize(void){return m_MaximizeButton;}
	ExCWindowButton *GetButtonMinimize(void){return m_MinimizeButton;}
	ExCWindowButton *GetButtonMinimizeToBar(void){return m_MinimizeToBarButton;}

	//Position and size
	void SetWindowSize(ExCVec2D vec);//{m_WindowSize=vec;}
	//inline ExCVec2D GetWindowSize(void){return m_WindowSize;}
	void SetOldWindowSize(ExCVec2D vec);//{m_OldSize=vec;}
	//inline ExCVec2D GetOldWindowSize(void){return m_OldSize;}
	void SetOldPosition(ExCVec2D vec);//{m_OldPosition=vec;}
	//inline ExCVec2D GetOldPosition(void){return m_OldPosition;}
	void SetTitleBarSize(float size);//{m_TitleBarSize=size;}
	//inline float GetTitleBarSize(void){return m_TitleBarSize;}
	void SetWindowPosition(ExCVec2D vec);
	inline bool IsShowWindowContent(void){return m_Window.IsShowWindow();}
	inline void	SetShowWindowContent(bool status){m_Window.SetShowWindow(status);}
	inline bool IsShowWindowBar(void){return m_TitleBar.IsShowWindow();}
	inline void	SetShowWindowBar(bool status){m_TitleBar.SetShowWindow(status);}
	//Title
	void SetWindowTitle(std::string Title);
	std::string GetWindowTitle(void);
	void SetWindowOldTitle(std::string Title);
	std::string GetWindowOldTitle(void);
	void	SetWindowTitleColor(ExCVec3D Color);
	ExCVec3D GetWindowTitleColor(void);

	bool PointInWindow(ExCVec2D point);

	bool LoadFile(std::string FileName);
	void ReadWindowSubObject(ExCWindow *win,std::string FileName);
	ExCWindowControl * ReadWindowControlObject(ExCWindowObject *win,std::string FileName);
};
//------------------------------------------------------------------------
#endif //__EXCWINDOW_H__
