/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 *
 */

#include "ExCWindowButton.h"
//--------------------------------
// Constructor // Destructor
//--------------------------------
ExCWindowButton::ExCWindowButton(void)
{
Guard(ExCWindowButton::ExCWindowButton(void))
	Init();
UnGuard
}

ExCWindowButton::ExCWindowButton(ExCVec2D Size,ExCVec2D Position)
{
Guard(ExCWindowButton::ExCWindowButton(ExCVec2D Size,ExCVec2D Position))
	Init();
	SetPosition(Position);
	SetOldPosition(Position);
	SetWindowSize(Size);
	SetOldWindowSize(Size);
UnGuard
}

ExCWindowButton::~ExCWindowButton(void)
{
}
//--------------------------------
// Methode
//--------------------------------
void ExCWindowButton::Init(void)
{
Guard(void ExCWindowButton::Init(void))
	ExCWindowObject::Init();
	SetName("ExCWindowButton");
	SetType(typeid(this).name());
	ShowWindowTitle(true);

UnGuard
}

void ExCWindowButton::Draw(void)
{
Guard(void ExCWindowButton::Draw(void))
	ExCWindowObject::Draw();
UnGuard
}

ExCAction ExCWindowButton::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExCWindowButton::InputCommand(ExCCommand Command))
	//std::cout<<"ExCWindowButton::Input Command window:"<<Command.m_Command<<std::endl;
	for(unsigned int i=0;i<m_VecCommandAction.size();i++)
	{
		if(m_VecCommandAction.at(i).first.m_Command==Command.m_Command)
		{
			return m_VecCommandAction.at(i).second;
		}
	}
	return NOTHING;
UnGuard
}

ExCAction ExCWindowButton::InputAction(ExCAction Action)
{
Guard(ExCAction ExCWindowButton::InputAction(ExCAction Action))
	return NOTHING;
UnGuard
}
