/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 *
 */

#include "ExCWindowButtonSwitchOnMouse.h"
//--------------------------------
// Constructor // Destructor
//--------------------------------
ExCWindowButtonSwitchOnMouse::ExCWindowButtonSwitchOnMouse(void)
{
Guard(ExCWindowButtonSwitchOnMouse::ExCWindowButtonSwitchOnMouse(void))
	Init();
UnGuard
}

ExCWindowButtonSwitchOnMouse::ExCWindowButtonSwitchOnMouse(ExCVec2D Size,ExCVec2D Position)
{
Guard(ExCWindowButtonSwitchOnMouse::ExCWindowButtonSwitchOnMouse(ExCVec2D Size,ExCVec2D Position))
	Init();
	SetPosition(Position);
	SetOldPosition(Position);
	SetWindowSize(Size);
	SetOldWindowSize(Size);
UnGuard
}

ExCWindowButtonSwitchOnMouse::~ExCWindowButtonSwitchOnMouse(void)
{
}
//--------------------------------
// Methode
//--------------------------------
void ExCWindowButtonSwitchOnMouse::Init(void)
{
Guard(void ExCWindowButtonSwitchOnMouse::Init(void))
	ExCWindowObject::Init();
	SetName("ExCWindowButtonSwitchOnMouse");
	SetType(typeid(this).name());
	ShowWindowTitle(true);
	m_StateButton=false;
UnGuard
}

void ExCWindowButtonSwitchOnMouse::Draw(void)
{
Guard(void ExCWindowButtonSwitchOnMouse::Draw(void))
	
	ExCWindowObject::Draw();
	//m_StateButton=false;
	
	if (m_StateButton)
	{
		std::cout<<"In button"<<std::endl;
	}else
	{
		std::cout<<"Out button"<<std::endl;
	}
	m_StateButton=false;
	SwitchValue();
UnGuard
}

ExCAction ExCWindowButtonSwitchOnMouse::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExCWindowButtonSwitchOnMouse::InputCommand(ExCCommand Command))
	//std::cout<<"ExCWindowButtonSwitchOnMouse::Input Command window:"<<Command.m_Command<<std::endl;
	/*if(Command.m_Command==MOUSE_MOTION_PASSIVE)
	{*/
		//std::cout<<"In button"<<std::endl;
		m_StateButton=true;
		this->SwitchValue();
	//}
	
	for(unsigned int i=0;i<m_VecCommandAction.size();i++)
	{
		if(m_VecCommandAction.at(i).first.m_Command==Command.m_Command)
		{
			//SwitchValue();
			return m_VecCommandAction.at(i).second;
		}
	}
	return NOTHING;
UnGuard
}

ExCAction ExCWindowButtonSwitchOnMouse::InputAction(ExCAction Action)
{
Guard(ExCAction ExCWindowButtonSwitchOnMouse::InputAction(ExCAction Action))
	return NOTHING;
UnGuard
}

void ExCWindowButtonSwitchOnMouse::SwitchValue(void)
{
Guard(void ExCWindowButtonSwitchOnMouse::SwitchValue(void))
	ExCWindowButton *ValueSource;
	if (m_StateButton)
	{
		ValueSource=m_Butt1;
	}else
	{
		ValueSource=m_Butt2;
	}
	//Title
	m_ShowWindowTitle=ValueSource->IsShowWindowTitle();
	m_WindowTitle=ValueSource->GetWindowTitle();
	m_WindowOldTitle=ValueSource->GetWindowOldTitle();
	m_WindowTitleColor=ValueSource->GetWindowTitleColor();
	//Color and blending
	m_Blending=ValueSource->IsBackroundBlending();
	m_BackroundBlending=ValueSource->GetBackroundBlending();
	m_BackroundColor=ValueSource->GetBackroundColor();
	//Border 
	m_BorderColor=ValueSource->GetBorderColor();
	m_BorderSize=ValueSource->GetBorderSize();
	m_ShowBorder=ValueSource->GetShowBorder();
	//Texturing
	m_BackroundIsTexturing1=ValueSource->IsBackroundTexturing1();
	m_BackroundTexture1=ValueSource->GetBackroundTexture1();
	m_BackroundIsTexturing2=ValueSource->IsBackroundTexturing2();
	m_BackroundTexture2=ValueSource->GetBackroundTexture2();
	m_TextureIsMouving=ValueSource->IsTextureIsMouving();
	m_TextureMouvingVec=ValueSource->GetTextureMouvingVec();
	m_VecCommandAction=ValueSource->GetVecActionCommand();
UnGuard
}
