/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 *
 */

#include "ExCWindowLabel.h"
//--------------------------------
// Constructor // Destructor
//--------------------------------
ExCWindowLabel::ExCWindowLabel(void)
{
Guard(ExCWindowLabel::ExCWindowLabel(void))
	Init();
UnGuard
}

ExCWindowLabel::ExCWindowLabel(ExCVec2D Size,ExCVec2D Position)
{
Guard(ExCWindowLabel::ExCWindowLabel(ExCVec2D Size,ExCVec2D Position))
	Init();
	SetPosition(Position);
	SetOldPosition(Position);
	SetWindowSize(Size);
	SetOldWindowSize(Size);
UnGuard
}

ExCWindowLabel::~ExCWindowLabel(void)
{
}
//--------------------------------
// Methode
//--------------------------------
void ExCWindowLabel::Init(void)
{
Guard(void ExCWindowLabel::Init(void))
	ExCWindowObject::Init();
	SetName("ExCWindowLabel");
	SetType(typeid(this).name());
	SetWindowTitle("Static Label");
	ShowWindowTitle(true);
	SetBackroundColor(ExCVec3D(0.98f,0.98f,0.98f));
	SetBorderColor(ExCVec3D(0.4f,0.4f,0.4f));
UnGuard
}

void ExCWindowLabel::Draw(void)
{
Guard(void ExCWindowLabel::Draw(void))
	ExCWindowObject::Draw();
UnGuard
}

ExCAction ExCWindowLabel::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExCWindowLabel::InputCommand(ExCCommand Command))
	//std::cout<<"ExCWindowLabel::Input Command window:"<<Command.m_Command<<std::endl;
	for(unsigned int i=0;i<m_VecCommandAction.size();i++)
	{
		if(m_VecCommandAction.at(i).first.m_Command==Command.m_Command)
		{
			return m_VecCommandAction.at(i).second;
		}
	}
	return NOTHING;
UnGuard
}

ExCAction ExCWindowLabel::InputAction(ExCAction Action)
{
Guard(ExCAction ExCWindowLabel::InputAction(ExCAction Action))
	return NOTHING;
UnGuard
}
