/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 *
 */

#include "ExCWindowMessageBoxQuestion.h"
//--------------------------------
// Constructor // Destructor
//--------------------------------
ExCWindowMessageBoxQuestion::ExCWindowMessageBoxQuestion(void)
{
Guard(ExCWindowMessageBoxQuestion::ExCWindowMessageBoxQuestion(void))
	Init();
UnGuard
}

ExCWindowMessageBoxQuestion::ExCWindowMessageBoxQuestion(std::string Message,ExCAction Yes,ExCAction No)
{
Guard(ExCWindowMessageBoxQuestion::ExCWindowMessageBoxQuestion(std::string Message,ExCAction Yes,ExCAction No))
	m_Message=Message;
	m_YesAction=Yes;
	m_NoAction=No;
	Init();
	RefreshSize();
	RefreshPosotion();
UnGuard
}

void ExCWindowMessageBoxQuestion::Init(void)
{
Guard(void ExCWindowMessageBoxQuestion::Init(void))
	ExCWindow::Init();
	SetName("ExCWindow");
	SetType(typeid(this).name());
	SetPosition(ExCVec2D(ExNihilo::GetResolutionX()/2-150,(ExNihilo::GetResolutionY()/2)-50));
	SetOldPosition(ExCVec2D(ExNihilo::GetResolutionX()/2-150,(ExNihilo::GetResolutionY()/2)-50));
	SetWindowSize(ExCVec2D(300,100));
	SetOldWindowSize(ExCVec2D(300,100));
	m_Window.SetBackroundColor(ExCVec3D(0.5f,0.5f,0.5f));
	m_Window.SetBorderColor(ExCVec3D(0.2f,0.2f,0.2f));
	m_YesButton = new ExCWindowButton;
	m_YesButton->SetWindowSize(ExCVec2D(50,20));
	m_YesButton->SetPosition(ExCVec2D(75,50));
	m_YesButton->SetWindowTitle("   YES   ");
	m_YesButton->ShowWindowTitle(true);
	m_YesButton->AddActionCommand(m_YesAction,ExCCommand(MOUSE_LEFT_BUTTON_DOWN));
	m_NoButton = new ExCWindowButton;
	m_NoButton->SetWindowSize(ExCVec2D(50,20));
	m_NoButton->SetPosition(ExCVec2D(175,50));
	m_NoButton->SetWindowTitle("   NO   ");
	m_NoButton->ShowWindowTitle(true);
	m_NoButton->AddActionCommand(m_NoAction,ExCCommand(MOUSE_LEFT_BUTTON_DOWN));
	m_Window.AddObjectControl(m_YesButton);
	m_Window.AddObjectControl(m_NoButton);
	m_CurrentSelection=true;
UnGuard
}

ExCWindowMessageBoxQuestion::~ExCWindowMessageBoxQuestion(void)
{
}

//--------------------------------
// Methode
//--------------------------------
void ExCWindowMessageBoxQuestion::Draw(void)
{
Guard(void ExCWindowMessageBoxQuestion::Draw(void))
	//std::cout<<"Draw ExCWindowMessageBoxQuestion"<<std::endl;
	ExNihilo::EnterOrthoMode();
	glPushAttrib(GL_ALL_ATTRIB_BITS);
		glDisable(GL_LIGHTING);
		if(m_CurrentSelection)
		{
			m_YesButton->SetBorderColor(ExCVec3D(0.0f,0.0f,0.0f));
			m_NoButton->SetBorderColor(ExCVec3D(0.4f,0.4f,0.4f));
		}
		else
		{
			m_YesButton->SetBorderColor(ExCVec3D(0.4f,0.4f,0.4f));
			m_NoButton->SetBorderColor(ExCVec3D(0.0f,0.0f,0.0f));
		}
		m_Window.Draw();
		glColor3f(0.0f,0.0f,0.0f);
		ExNihilo::WriteToScreen(m_Position.GetX()+5,m_Position.GetY()+5+m_WindowSize.GetY()/2,m_Message);
	glPopAttrib();
	ExNihilo::LeaveOrthoMode();
UnGuard
}



ExCAction ExCWindowMessageBoxQuestion::InputCommand(ExCCommand Command)
{
Guard(ExCAction ExCWindowMessageBoxQuestion::InputCommand(ExCCommand Command))
	//std::cout<<"ExCWindow::Input Command window:"<<Command.m_Command<<std::endl;
	switch(Command.m_Command)
	{
	case KEYBOARD_DOWN_ENTER:
		m_BeClosed=true;
		if(m_CurrentSelection)
		{
			std::cout<<"YesAction:"<<m_YesAction<<std::endl;
			return m_YesAction;
		}
		else
		{
			
			return m_NoAction;
		}
		return CLOSE_OBJECT_WINDOW;
	case KEYBOARD_DOWN_ARROW_LEFT:
	case KEYBOARD_DOWN_ARROW_RIGHT:	
		if(m_CurrentSelection){m_CurrentSelection=false;}
		else m_CurrentSelection=true;
		break;
	case MOUSE_LEFT_BUTTON_DOWN:
		if(m_TitleBar.PointInWindow(ExCVec2D(Command.m_MousePosx,Command.m_MousePosy)))
		{
			m_BeClosed=true;
			return InputAction(m_TitleBar.InputCommand(Command));
		}
		if(m_Window.PointInWindow(ExCVec2D(Command.m_MousePosx,Command.m_MousePosy)))
		{
			m_BeClosed=true;
			return InputAction(m_Window.InputCommand(Command));
		}

		break;
	}
	
	return NOTHING;
UnGuard
}

ExCAction ExCWindowMessageBoxQuestion::InputAction(ExCAction Action)
{
Guard(ExCAction ExCWindowMessageBoxQuestion::InputAction(ExCAction Action))
	/*switch(Action.m_Action)
	{
	default:
		return Action;
	}
	if(Action.m_NextAction){return *Action.m_NextAction;}
	else{return NOTHING;}*/
	return Action;
UnGuard
}


