/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCWindowObject.h										*/
/*																		*/
/* Star Date   :03/14/2003												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __ExCWindowObject_H__
#define __ExCWindowObject_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Object/Object2D/ExCObject2D.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerTexture.h"
//------------------------------------------------------------------------
#include "Manager/ExManagerWindow.h"
//------------------------------------------------------------------------
class ExCWindowObject :public ExCObject2D
{
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
protected:
	ExManagerTexture			*ManagerTexture;
	ExManagerWindow				*ManagerWindow;
	
	ExCWindowObject				*m_Parent;
	
	ExCVec2D					m_OldMousePosition;

	//Title
	bool		m_ShowWindowTitle;
	std::string	m_WindowTitle;
	std::string	m_WindowOldTitle;
	ExCVec3D	m_WindowTitleColor;
	//Size and position
	ExCVec2D	m_WindowSize;
	ExCVec2D	m_OldSize;
	ExCVec2D	m_OldPosition;
	//Color and blending
	bool		m_Blending;	
	ExCVec3D	m_BackroundColor;
	float		m_BackroundBlending;
	//Border 
	ExCVec3D	m_BorderColor;
	float		m_BorderSize;
	bool		m_ShowBorder;
	//Texturing
	bool		m_BackroundIsTexturing1;
	std::string m_BackroundTexture1;
	bool		m_BackroundIsTexturing2;
	std::string m_BackroundTexture2;
	bool		m_TextureIsMouving;
	ExCVec2D	m_TextureMouvingVec;

public:
//------------------------------------------------------------------------
// Constructor // Destructor
//------------------------------------------------------------------------
	ExCWindowObject(void);
	ExCWindowObject(ExCVec2D Size);
	//inline ExCWindowObject(float x,float y){ExCWindowObject(ExCVec2D(x,y));};
	ExCWindowObject(ExCVec2D Size,ExCVec2D Position);
	/*inline ExCWindowObject(float x,float y,float xp,float yp)
		{ExCWindowObject(ExCVec2D(x,y),ExCVec2D(xp,yp));};*/
	ExCWindowObject(ExCVec2D Size,ExCVec2D Position,std::string Title);
	/*inline ExCWindowObject(float x,float y,float xp,float yp,std::string Title)
		{ExCWindowObject(ExCVec2D(x,y),ExCVec2D(xp,yp),Title);}*/
	~ExCWindowObject(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	void SetPosition(ExCVec2D Position);
	void SetManagerTexture(ExManagerTexture * Texture);
	inline void SetManagerWindow(ExManagerWindow *Window){ManagerWindow = Window;}
	
	inline void SetParrent(ExCWindowObject *Parent){m_Parent=Parent;}
	inline ExCWindowObject* GetParrent(void){return m_Parent;}

	void Init(void);
	virtual void Draw(void);
	virtual ExCAction InputAction(ExCAction Action);
	virtual ExCAction InputCommand(ExCCommand Command);

	//Title
	inline void ShowWindowTitle(bool state){m_ShowWindowTitle=state;}
	inline bool IsShowWindowTitle(void){return m_ShowWindowTitle;}
	inline void SetWindowTitle(std::string Title){m_WindowTitle=Title;}
	inline std::string GetWindowTitle(void){return m_WindowTitle;}
	inline void SetWindowOldTitle(std::string Title){m_WindowOldTitle=Title;}
	inline std::string GetWindowOldTitle(void){return m_WindowOldTitle;}
	inline void	SetWindowTitleColor(ExCVec3D Color){m_WindowTitleColor=Color;}	
	inline ExCVec3D GetWindowTitleColor(void){return m_WindowTitleColor;}

	//Position and size
	inline void SetWindowSize(ExCVec2D vec){m_WindowSize=vec;}
	inline ExCVec2D GetWindowSize(void){return m_WindowSize;}
	inline void SetOldWindowSize(ExCVec2D vec){m_OldSize=vec;}
	inline ExCVec2D GetOldWindowSize(void){return m_OldSize;}
	inline void SetOldPosition(ExCVec2D vec){m_OldPosition=vec;}
	inline ExCVec2D GetOldPosition(void){return m_OldPosition;}

	//Check location
	bool PointInWindow(ExCVec2D point);
	//Texturing
	inline bool IsBackroundTexturing1(void){return m_BackroundIsTexturing1;}
	inline void	SetBackroundTexturing1(bool status,std::string texture){m_BackroundIsTexturing1=status;m_BackroundTexture1=texture;}
	inline std::string GetBackroundTexture1(void){return m_BackroundTexture1;}
	inline bool IsBackroundTexturing2(void){return m_BackroundIsTexturing2;}
	inline void	SetBackroundTexturing2(bool status,std::string texture){m_BackroundIsTexturing2=status;m_BackroundTexture2=texture;}
	inline std::string GetBackroundTexture2(void){return m_BackroundTexture2;}
	inline bool IsTextureIsMouving(void){return m_TextureIsMouving;}
	inline void SetTextureIsMouving(bool state){m_TextureIsMouving=state;}
	inline void SetTextureMouvingVec(ExCVec2D vec){m_TextureMouvingVec=vec;}
	inline ExCVec2D GetTextureMouvingVec(void ){return m_TextureMouvingVec;}
	//Color and blending
	inline bool IsBackroundBlending(void){return m_Blending;}
	inline float GetBackroundBlending(void){return m_BackroundBlending;}
	inline void SetBackroundBlending(bool state){m_Blending=state;}
	inline void SetBackroundBlending(bool state,float value){m_Blending=state;m_BackroundBlending=value;}
	inline void	SetBackroundColor(ExCVec3D Color){m_BackroundColor=Color;}	
	inline ExCVec3D GetBackroundColor(void){return m_BackroundColor;}
	//Border Size en color
	inline void SetBorderSize(float value){m_BorderSize=value;}
	inline float GetBorderSize(void){return m_BorderSize;}
	inline void	SetBorderColor(ExCVec3D Color){m_BorderColor=Color;}	
	inline ExCVec3D GetBorderColor(void){return m_BorderColor;}
	inline bool GetShowBorder(void){return m_ShowBorder;}
	inline void	SetShowBorder(bool status){m_ShowBorder=status;}

	//Load
	void Load(std::ifstream *file);
	std::string Load(std::string FileName);

};
//------------------------------------------------------------------------
#endif //__ExCWindowObject_H__
