/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 *
 */

#include "ExCWindowTitleBar.h"
//--------------------------------
// Constructor // Destructor
//--------------------------------
ExCWindowTitleBar::ExCWindowTitleBar(void)
{
Guard(ExCWindowTitleBar::ExCWindowTitleBar(void))
	SetName("ExCWindowTitleBar");
	SetType(typeid(this).name());
	m_TitleBarSize=20;
	Init();
UnGuard
}

ExCWindowTitleBar::~ExCWindowTitleBar(void)
{
}
//--------------------------------
// Methode
//--------------------------------
void ExCWindowTitleBar::Init(void)
{
Guard(void ExCWindowTitleBar::Init(void))
	ExCWindowObject::Init();	
	//-----------------------------
	//Create Bar
	//-----------------------------
	SetName("BarWindow"+GetWindowTitle());
	ShowWindowTitle(true);
	SetWindowTitle(GetWindowTitle());
	SetWindowTitleColor(ExCVec3D(0.5f,0.0f,0.0f));
	SetBackroundTexturing1(true,"bar");
	SetBackroundTexturing2(true,"back3");
	SetTextureIsMouving(true);
	SetTextureMouvingVec(ExCVec2D(0.0001f,0.0f));
	SetBackroundColor(ExCVec3D(1.0f,1.0f,1.0f));
	SetCanMouve(true);
	SetBorderColor(ExCVec3D(0.5f,0.5f,0.5f));
	//------------------------------
	m_CloseButton = new ExCWindowButton;
	m_MaximizeButton = new ExCWindowButton;
	m_MinimizeButton = new ExCWindowButton;
	m_MinimizeToBarButton = new ExCWindowButton;
	//------------------------------
	m_CloseButton->SetName("CloseButton");
	m_CloseButton->SetBackroundTexturing1(true,"ButtClose.bmp");
	m_CloseButton->SetBackroundTexturing2(false,"NONE");
	m_CloseButton->SetBackroundColor(ExCVec3D(0.5f,0.5f,0.5f));
	m_CloseButton->AddActionCommand(ExCAction(CLOSE_OBJECT_WINDOW),ExCCommand(MOUSE_LEFT_BUTTON_DOWN));
	//------------------------------
	m_MaximizeButton->SetName("ButtMax");
	m_MaximizeButton->SetBackroundTexturing1(true,"ButtMax.bmp");
	m_MaximizeButton->SetBackroundTexturing2(false,"NONE");
	m_MaximizeButton->SetBackroundColor(ExCVec3D(0.5f,0.5f,0.5f));
	m_MaximizeButton->AddActionCommand(ExCAction(MAXIMIZE_OBJECT_WINDOW),ExCCommand(MOUSE_LEFT_BUTTON_DOWN));
	//------------------------------
	m_MinimizeButton->SetName("ButtMin");
	m_MinimizeButton->SetBackroundTexturing1(true,"ButtMin.bmp");
	m_MinimizeButton->SetBackroundTexturing2(false,"NONE");
	m_MinimizeButton->SetBackroundColor(ExCVec3D(0.5f,0.5f,0.5f));
	m_MinimizeButton->AddActionCommand(ExCAction(MINIMIZE_OBJECT_WINDOW),ExCCommand(MOUSE_LEFT_BUTTON_DOWN));
	//------------------------------
	m_MinimizeToBarButton->SetName("ButtBar");
	m_MinimizeToBarButton->SetBackroundTexturing1(true,"ButtBar.bmp");
	m_MinimizeToBarButton->SetBackroundTexturing2(false,"NONE");
	m_MinimizeToBarButton->SetBackroundColor(ExCVec3D(0.5f,0.5f,0.5f));
	m_MinimizeToBarButton->AddActionCommand(ExCAction(MINIMIZE_TO_BAR_OBJECT_WINDOW),ExCCommand(MOUSE_LEFT_BUTTON_DOWN));

	m_CloseButton->SetWindowSize(ExCVec2D(m_TitleBarSize-3,m_TitleBarSize-4));
	m_MaximizeButton->SetWindowSize(ExCVec2D(m_TitleBarSize-3,m_TitleBarSize-4));
	m_MinimizeButton->SetWindowSize(ExCVec2D(m_TitleBarSize-3,m_TitleBarSize-4));
	m_MinimizeToBarButton->SetWindowSize(ExCVec2D(m_TitleBarSize-3,m_TitleBarSize-4));

	m_CloseButton->SetPosition(ExCVec2D(GetPosition().GetX()+m_WindowSize.GetX()-m_TitleBarSize,GetPosition().GetY()+2));
	m_MaximizeButton->SetPosition(ExCVec2D(GetPosition().GetX()+m_WindowSize.GetX()-m_TitleBarSize*2,GetPosition().GetY()+2));
	m_MinimizeButton->SetPosition(ExCVec2D(GetPosition().GetX()+m_WindowSize.GetX()-m_TitleBarSize*3,GetPosition().GetY()+2));
	m_MinimizeToBarButton->SetPosition(ExCVec2D(GetPosition().GetX()+m_WindowSize.GetX()-m_TitleBarSize*4,GetPosition().GetY()+2));


	AddObjectControl(m_CloseButton);
	AddObjectControl(m_MaximizeButton);
	AddObjectControl(m_MinimizeButton);
	AddObjectControl(m_MinimizeToBarButton);

UnGuard
}

void ExCWindowTitleBar::Draw(void)
{
Guard(void ExCWindowTitleBar::Draw(void))
	ExCWindowObject::Draw();	
UnGuard
}

bool ExCWindowTitleBar::LoadFile(std::string FileName)
{
Guard(void ExCWindowTitleBar::LoadFile(std::string FileName))
	/*char			buffer[255],b[255];
	std::string buffstring;
	std::ifstream file,fileButton,fileControl;
	#ifdef UNIX_SRC
	sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", FileName.data());
	#else
	sprintf(buffer, "../Data/Window/%s", FileName.data());
	#endif
	std::cout<<buffer<<std::endl;
	file.open(buffer,std::ios::in);
	if(file.is_open())
	{
		memset(b,0,255);file.getline(b,256,'\n');
		try
		{
			buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
			Load(&file);
			//READ CLOSE BUTTON
			memset(b,0,255);file.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<FileForButtonClose>","<#FileForButtonClose>");
			#ifdef UNIX_SRC
			sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", buffstring.data());
			#else
			sprintf(buffer, "../Data/Window/%s", buffstring.data());
			#endif
			fileButton.open(buffer,std::ios::in);
			if(fileButton.is_open())
			{
				memset(b,0,255);fileButton.getline(b,256,'\n');
				buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
				m_CloseButton->Load(&fileButton);
				m_CloseButton->SetBackroundColor(ExCVec3D(1.0f,1.0f,1.0f));
			}fileButton.close();
			//READ Maximize BUTTON
			memset(b,0,255);file.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<FileForButtonMaximize>","<#FileForButtonMaximize>");
#ifdef UNIX_SRC
			sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", buffstring.data());
#else
			sprintf(buffer, "../Data/Window/%s", buffstring.data());
#endif
			fileButton.open(buffer,std::ios::in);
			if(fileButton.is_open())
			{
				memset(b,0,255);fileButton.getline(b,256,'\n');
				buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
				m_MaximizeButton->Load(&fileButton);
				m_MaximizeButton->SetBackroundColor(ExCVec3D(1.0f,1.0f,1.0f));
			}fileButton.close();
			//READ Minimize BUTTON
			memset(b,0,255);file.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<FileForButtonMinimize>","<#FileForButtonMinimize>");
#ifdef UNIX_SRC
			sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", buffstring.data());
#else
			sprintf(buffer, "../Data/Window/%s", buffstring.data());
#endif
			fileButton.open(buffer,std::ios::in);
			if(fileButton.is_open())
			{
				memset(b,0,255);fileButton.getline(b,256,'\n');
				buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
				m_MinimizeButton->Load(&fileButton);
				m_MinimizeButton->SetBackroundColor(ExCVec3D(1.0f,1.0f,1.0f));
			}fileButton.close();
			//READ MinimizeToBar BUTTON
			memset(b,0,255);file.getline(b,256,'\n');
			buffstring=ExNihilo::ExtracValueFromSring(b,"<FileForButtonMinimizeToBar>","<#FileForButtonMinimizeToBar>");
#ifdef UNIX_SRC
			sprintf(buffer, PREFIX "/ExNihilo/Data/Window/%s", buffstring.data());
#else
			sprintf(buffer, "../Data/Window/%s", buffstring.data());
#endif
			fileButton.open(buffer,std::ios::in);
			if(fileButton.is_open())
			{
				memset(b,0,255);fileButton.getline(b,256,'\n');
				buffstring=ExNihilo::ExtracValueFromSring(b,"<WindowHeader>","<#WindowHeader>");
				//ReadWindowObject(win->GetButtonMinimizeToBar(),&fileButton);
				m_MinimizeToBarButton->Load(&fileButton);
				m_MinimizeToBarButton->SetBackroundColor(ExCVec3D(1.0f,1.0f,1.0f));
			}fileButton.close();

			
		}catch(ExCExpStringNotFound)
		{
			std::cout<<"ReadWindowSubObject::ExCExpStringNotFound";
		}
	}else throw   ExCExpFileNotFound();
	file.close();
		*/
UnGuard
}