/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCCamera.cpp,v 1.13 2002/12/13 11:45:02 data Exp $
 *
 */

#include "ExCCamera.h"


ExCCamera::ExCCamera(void)
{
Guard(ExCCamera::ExCCamera(void))
	//m_Angle.SetValue(300,180,0);
	m_speed=0;
	m_ZoomDefault=40;
	m_Zoom=m_ZoomDefault;
	m_ZoomMin=1;
	m_ZoomMax=100;
	m_ClipFar=100000000;
	m_ClipNear=1;
	SetName("ExCCamera");
	SetType(typeid(this).name());
	m_ShowInfo=true;
	//m_Position.SetValue(2318,634,1409);
UnGuard
}

ExCCamera::~ExCCamera(void)
{
Guard(ExCCamera::~ExCCamera(void))
UnGuard
}

void ExCCamera::DrawCameraGizmo(void)
{
	glColor4f(0.2,0.2,1,1);

	glPushMatrix();
	glTranslatef(m_Position.GetX(),m_Position.GetY(),m_Position.GetZ());
	glutWireSphere(0.5,4,4);

	glColor3f(0.5,0,0.5);

	glBegin(GL_LINES);
		glVertex3fv(m_Position.m_Vector);
		glVertex3fv(m_Target.m_Vector);
	glEnd();

	glPopMatrix();
}

void ExCCamera::Draw(void)
{
Guard(ExCCamera::Draw(void))
//cout<<"Draw "<<m_ObjectName<<" ID:"<<m_ObjectId<<endl;
	Process();

	if(m_Angle.GetX()<0)m_Angle.SetX(359+m_Angle.GetX());
	if(m_Angle.GetX()>359)m_Angle.SetX(359-m_Angle.GetX());
	if(m_Angle.GetY()<0)m_Angle.SetY(359+m_Angle.GetY());
	if(m_Angle.GetY()>359)m_Angle.SetY(359-m_Angle.GetY());
	if(m_Angle.GetZ()<0)m_Angle.SetZ(359+m_Angle.GetZ());
	if(m_Angle.GetZ()>359)m_Angle.SetZ(359-m_Angle.GetZ());

	float cosY,cosP,cosR;
	float sinY,sinP,sinR;

	cosY=cosf(DegreesToRadians(GetAngleY()));
	cosP=cosf(DegreesToRadians(GetAngleX()));
	cosR=cosf(DegreesToRadians(GetAngleZ()));

	sinY=sinf(DegreesToRadians(GetAngleY()));
	sinP=sinf(DegreesToRadians(GetAngleX()));
	sinR=sinf(DegreesToRadians(GetAngleZ()));

	

	fwd.SetX(sinY*cosP);
	fwd.SetY(sinP);
	fwd.SetZ(cosP*-cosY);

	m_Target=fwd+m_Position;
	

	m_Up.SetX((-cosY*sinR)-(sinY*sinP*cosR));
	m_Up.SetY(cosP*cosR);
	m_Up.SetZ((-sinY*sinR)-(sinP*cosR*-cosY));




   	gluLookAt(m_Position.GetX(),m_Position.GetY(),m_Position.GetZ()
			,m_Target.GetX(),m_Target.GetY(),m_Target.GetZ()
			,m_Up.GetX(),m_Up.GetY(),m_Up.GetZ());
	
	m_Position=m_Position+((m_Target-m_Position)*m_speed);
	//if(m_ShowInfo)DrawCameraInfo();



UnGuard
}
void ExCCamera::DrawCameraInfo(void)
{
Guard(void ExCCamera::DrawCameraInfo(void))
	glColor3f(1,1,1);
	char buff[255];
	memset(buff,0,255);
	//sprintf(buff,"Camera Name:%s",m_ObjectName);
	ExNihilo::WriteToScreen(30,520,buff);
	memset(buff,0,255);
	sprintf(buff,"Camera position X:%f Y:%f Z:%f",m_Position.GetX(),m_Position.GetY(),m_Position.GetZ());
	ExNihilo::WriteToScreen(30,540,buff);
	memset(buff,0,255);
	sprintf(buff,"Camera fwd X:%f Y:%f Z:%f",fwd.GetX(),fwd.GetY(),fwd.GetZ());
	ExNihilo::WriteToScreen(30,560,buff);
	memset(buff,0,255);
	sprintf(buff,"Camera target X:%f Y:%f Z:%f",m_Target.GetX(),m_Target.GetY(),m_Target.GetZ());
	ExNihilo::WriteToScreen(30,580,buff);
	memset(buff,0,255);
	sprintf(buff,"Camera angle X:%f Y:%f Z:%f",m_Angle.GetX(),m_Angle.GetY(),m_Angle.GetZ());
	ExNihilo::WriteToScreen(30,600,buff);

UnGuard
}

void ExCCamera::ResetZoom(void)
{
Guard(void ExCCamera::ResetZoom(void))
	m_Zoom=m_ZoomDefault;
UnGuard
}

void ExCCamera::SetZoomDefault(float zoom)
{
Guard(void ExCCamera:: SetZoomDefault(float zoom))
	if(zoom<m_ZoomMax&&zoom>m_ZoomMin)
		m_ZoomDefault=zoom;
UnGuard
}

void ExCCamera::ZoomIn(void)
{
Guard(void ExCCamera::ZoomIn(void))
	m_Zoom--;
	if(m_Zoom<=m_ZoomMin)m_Zoom=m_ZoomMin+1;
UnGuard
}

void ExCCamera::ZoomOut(void)
{
Guard(void ExCCamera::ZoomOut(void))
	m_Zoom++;
	if(m_Zoom>=m_ZoomMax)m_Zoom=m_ZoomMax-1;
UnGuard
}

void ExCCamera::ZoomIn(float zoom)
{
Guard(void ExCCamera::ZoomIn(float zoom))
	m_Zoom=m_Zoom-zoom;
	if(m_Zoom<=m_ZoomMin)m_Zoom=m_ZoomMin+1;
UnGuard
}

void ExCCamera::ZoomOut(float zoom)
{
Guard(void ExCCamera::ZoomOut(float zoom))
	m_Zoom=m_Zoom+m_ZoomMax;
	if(m_Zoom>=m_ZoomMax)m_Zoom=m_ZoomMax-1;
UnGuard
}

void ExCCamera::SetZoom(float zoom)
{
Guard(void ExCCamera::SetZoom(float zoom))
UnGuard
}

void ExCCamera::SetZoomMax(float zoom)
{
Guard(void ExCCamera::SetZoomMax(float zoom))
UnGuard
}

void ExCCamera::SetZoomMin(float zoom)
{
Guard(void ExCCamera::SetZoomMin(float zoom))
UnGuard
}

void ExCCamera::SetClipFar(float clip)
{
	Guard(void ExCCamera::SetClipFar(float clip))
	m_ClipFar=clip;
	if(m_ClipFar<m_ClipNear)m_ClipFar=m_ClipNear+1;
UnGuard
}

void ExCCamera::SetClipNear(float clip)
{
	Guard(void ExCCamera::SetClipNear(float clip))
	m_ClipNear=clip;
	if(m_ClipNear>m_ClipFar)m_ClipNear=m_ClipFar-1;
UnGuard
}

void ExCCamera::Process(void)
{
Guard(void ExCCamera::Process(void))
	for(unsigned i=0;i<m_VecAction.size();i++)
	{
		switch(m_VecAction.at(i)) 
		{
		case ROTATE_Z_UP:m_Angle.IncZ();break;
		case ROTATE_Y_UP:m_Angle.IncY();break;
		case ROTATE_X_UP:m_Angle.IncX();break;
		case ROTATE_Z_DOWN:m_Angle.DecZ();break;
		case ROTATE_Y_DOWN:m_Angle.DecY();break;
		case ROTATE_X_DOWN:m_Angle.DecX();break;
		case ZOOM_UP:ZoomOut();break;
		case ZOOM_DOWN:ZoomIn();break;
		case SPEED_UP:break;
		case SPEED_DOWN:break;
		}
	}
UnGuard
}

void ExCCamera::StartAction(int Action)
{
Guard(void ExCCamera::StartAction(int Action))
	m_VecAction.push_back(Action);
UnGuard
}

void ExCCamera::StopAction(int Action)
{
Guard(void ExCCamera::StopAction(int Action))
	for(m_ItVecAction=m_VecAction.begin();m_ItVecAction!=m_VecAction.end();m_ItVecAction++)
	{
		if(*m_ItVecAction==Action){m_VecAction.erase(m_ItVecAction);return;}
	}
UnGuard
}
