/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCParticuleTexture.h									*/
/*																		*/
/* Start Date   :06/20/2003												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXCCAMERA_H__
#define __EXCCAMERA_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
#include "ExCAction.h"		
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Object/Object3D/ExCObject3D.h"
//------------------------------------------------------------------------
#include "Manager/ExManagerCollision.h"
//------------------------------------------------------------------------
class ExCCamera : public ExCObject3D
{
protected:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	bool m_Actif;
	float m_Zoom;
	float m_ClipFar;
	float m_ClipNear;
	float m_ZoomDefault;
	float m_ZoomMax;
	float m_ZoomMin;
	ExCVec3D fwd,side;
public:
	
//------------------------------------------------------------------------
// Constructor // Destructor
//------------------------------------------------------------------------
	ExCCamera(void);
	~ExCCamera(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	virtual void Draw(void);
	void DrawCameraGizmo(void);
	void DrawCameraInfo(void);
	
	//ZOOM FUNCTION
	void ZoomIn(void);
	void ZoomOut(void);
	void ResetZoom(void);
	void ZoomIn(float zoom);
	void ZoomOut(float zoom);
	void SetZoom(float zoom);
	void SetZoomMax(float zoom);
	void SetZoomMin(float zoom);
	void SetZoomDefault(float zoom);
	float GetZoomMax(void){return m_ZoomMax;}
	float GetZoomMin(void){return m_ZoomMin;}
	float GetZoom(void){return m_Zoom;}
	float GetZoomDefault(void){return m_ZoomDefault;}
	//CLIPPING FUNCTION
	void SetClipFar(float clip);
	void SetClipNear(float clip);
	float GetClipFar(void){return m_ClipFar;}
	float GetClipNear(void){return m_ClipNear;}

	int							m_CurrentAction;
	std::vector<int>			m_VecAction;
	std::vector<int>::iterator	m_ItVecAction;

	void StartAction(int Action);
	void StopAction(int Action);
	void Process(void);
};
//------------------------------------------------------------------------
#endif //__EXCCAMERA_H__
