/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCCameraChase.cpp,v 1.5 2002/09/03 00:00:02 data Exp $
 *
 */

#include "ExCCameraChase.h"


ExCCameraChase::ExCCameraChase()
{
Guard(ExCCameraChase::ExCCameraChase())
	SetName("ExCCameraChase");
	SetType(typeid(this).name());
	m_DistanceFromTarget=80.0f;
	m_AngleAroundTarget=180;
	m_CameraHeight=0.0f;
UnGuard
}

ExCCameraChase::~ExCCameraChase()
{
Guard(ExCCameraChase::~ExCCameraChase())
UnGuard
}

void ExCCameraChase::Draw(void)
{
Guard(void ExCCameraChase::Draw(void))
	ExCVec3D fwd;
	float TargetAngleY,TargetAngleZ;	
	//Test if there is one object
	if(ManagerModel->GetCurrentObject()>0)
	{
		m_Target=fwd+ManagerModel->GetCurrentObject()->GetPosition();
		m_Target.IncY(25);
		TargetAngleY=ManagerModel->GetCurrentObject()->GetAngleY();
		TargetAngleZ=ManagerModel->GetCurrentObject()->GetAngleZ();
	}else //Transform the cam into free cam
	{
		ExCCamera::Draw();
		return;
	}
	Process();
	
	if(m_Angle.GetX()<0)m_Angle.SetX(359);
	if(m_Angle.GetX()>359)m_Angle.SetX(0);
	if(m_Angle.GetY()<0)m_Angle.SetY(359);
	if(m_Angle.GetY()>359)m_Angle.SetY(0);
	if(m_Angle.GetZ()<0)m_Angle.SetZ(359);
	if(m_Angle.GetZ()>359)m_Angle.SetZ(0);

	float cosY,cosP,cosR;
	float sinY,sinP,sinR;

	cosY=cosf(DegreesToRadians(GetAngleY()));
	cosP=cosf(DegreesToRadians(GetAngleX()));
	cosR=cosf(DegreesToRadians(GetAngleZ()));

	sinY=sinf(DegreesToRadians(GetAngleY()));
	sinP=sinf(DegreesToRadians(GetAngleX()));
	sinR=sinf(DegreesToRadians(GetAngleZ()));	

	fwd.SetX(sinY*cosP);
	fwd.SetY(sinP);
	fwd.SetZ(cosP*-cosY);

	m_Position.SetX(cosf(DegreesToRadians(TargetAngleY+m_AngleAroundTarget))*m_DistanceFromTarget);
	m_Position.SetY(m_CameraHeight);
	m_Position.SetZ(sinf(DegreesToRadians(TargetAngleY+m_AngleAroundTarget))*m_DistanceFromTarget);

	m_Position=m_Position+m_Target;

	m_Up.SetX((-cosY*sinR)-(sinY*sinP*cosR));
	m_Up.SetY(cosP*cosR);
	m_Up.SetZ((-sinY*sinR)-(sinP*cosR*-cosY));

	gluLookAt(m_Position.GetX(),m_Position.GetY(),m_Position.GetZ()
			,m_Target.GetX(),m_Target.GetY(),m_Target.GetZ()
			,m_Up.GetX(),m_Up.GetY(),m_Up.GetZ());

UnGuard
}

void ExCCameraChase::Process(void)
{
Guard(void ExCCameraChase::Process(void))
	for(unsigned i=0;i<m_VecAction.size();i++)
	{
		switch(m_VecAction.at(i)) 
		{
		case ANGLE_AROUND_TARGET_UP:
			m_AngleAroundTarget=m_AngleAroundTarget+0.5;
			break;
		case ANGLE_AROUND_TARGET_DOWN:
			m_AngleAroundTarget=m_AngleAroundTarget-0.5;
			break;
		case DISTANCE_FROM_TARGET_UP:m_DistanceFromTarget++;break;
		case DISTANCE_FROM_TARGET_DOWN:m_DistanceFromTarget--;break;
		case HEIGHT_FROM_TARGET_UP:m_CameraHeight++;break;
		case HEIGHT_FROM_TARGET_DOWN:m_CameraHeight--;break;
		default:ExCCamera::Process();
		}
	}
UnGuard
}