/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCCameraFirst.cpp,v 1.4 2002/08/14 15:20:53 data Exp $
 *
 */

#include "ExCCameraFirst.h"


ExCCameraFirst::ExCCameraFirst()
{
Guard(ExCCameraFirst::ExCCameraFirst())
	SetName("ExCCameraFirst");
	SetType(typeid(this).name());
	WalkFalg=true;
UnGuard
}

ExCCameraFirst::~ExCCameraFirst()
{
Guard(ExCCameraFirst::~ExCCameraFirst())
UnGuard
}

void ExCCameraFirst::Draw(void)
{
Guard(void ExCCameraFirst::Draw(void))
	//Test if there is one object
	if(ManagerModel->GetCurrentObject()>0)
	{
		m_Position=ManagerModel->GetCurrentObject()->GetPosition();
		m_Target=ManagerModel->GetCurrentObject()->GetTarget();
	}else //Transform the cam into free cam
	{
		ExCCamera::Draw();
		return;
	}
	Process();
	
	if(m_Angle.GetX()<0)m_Angle.SetX(359);
	if(m_Angle.GetX()>359)m_Angle.SetX(0);
	if(m_Angle.GetY()<0)m_Angle.SetY(359);
	if(m_Angle.GetY()>359)m_Angle.SetY(0);
	if(m_Angle.GetZ()<0)m_Angle.SetZ(359);
	if(m_Angle.GetZ()>359)m_Angle.SetZ(0);

	float cosY,cosP,cosR;
	float sinY,sinP,sinR;

	cosY=cosf(DegreesToRadians(GetAngleY()));
	cosP=cosf(DegreesToRadians(GetAngleX()));
	cosR=cosf(DegreesToRadians(GetAngleZ()));

	sinY=sinf(DegreesToRadians(GetAngleY()));
	sinP=sinf(DegreesToRadians(GetAngleX()));
	sinR=sinf(DegreesToRadians(GetAngleZ()));	

	m_Position.SetY(m_Position.GetY()+12.0f);
	m_Target.SetY(m_Target.GetY()+12.0f);	

	gluLookAt(m_Position.GetX(),m_Position.GetY(),m_Position.GetZ()
			,m_Target.GetX(),m_Target.GetY(),m_Target.GetZ()
			,(-cosY*sinR)-(sinY*sinP*cosR),(cosP*cosR),(-sinY*sinR)-(sinP*cosR*-cosY));
UnGuard
}

void ExCCameraFirst::Process(void)
{
Guard(void ExCCameraFirst::Process(void))
	for(unsigned i=0;i<m_VecAction.size();i++)
	{
		/*switch(m_VecAction.at(i)) 
		{
		default:ExCCamera::Process();
		}*/
		ExCCamera::Process();
	}
UnGuard
}