/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 

 *
 */

#include "ExCCameraFlight.h"


ExCCameraFlight::ExCCameraFlight()
{
Guard(ExCCameraFlight::ExCCameraFlight())
	SetName("ExCCameraFlight");
	SetType(typeid(this).name());
UnGuard
}

ExCCameraFlight::~ExCCameraFlight()
{
Guard(ExCCameraFlight::~ExCCameraFlight())
	
UnGuard
}

void ExCCameraFlight::Draw(void)
{
Guard(ExCCameraFlight::Draw(void))
	Process();
	if(m_Angle.GetX()<0)m_Angle.SetX(359);
	if(m_Angle.GetX()>359)m_Angle.SetX(0);
	if(m_Angle.GetY()<0)m_Angle.SetY(359);
	if(m_Angle.GetY()>359)m_Angle.SetY(0);
	if(m_Angle.GetZ()<0)m_Angle.SetZ(359);
	if(m_Angle.GetZ()>359)m_Angle.SetZ(0);

	//315/45
	if(m_Angle.GetZ()>45&&m_Angle.GetZ()<180)m_Angle.SetZ(45);
	if(m_Angle.GetZ()>180&&m_Angle.GetZ()<315)m_Angle.SetZ(315);
	
	float cosY,cosP,cosR;
	float sinY,sinP,sinR;

	cosY=cosf(DegreesToRadians(m_Angle.GetY()));
	cosP=cosf(DegreesToRadians(m_Angle.GetX()));
	cosR=cosf(DegreesToRadians(m_Angle.GetZ()));

	sinY=sinf(DegreesToRadians(m_Angle.GetY()));
	sinP=sinf(DegreesToRadians(m_Angle.GetX()));
	sinR=sinf(DegreesToRadians(m_Angle.GetZ()));	

	fwd.SetX(sinY*cosP);
	fwd.SetY(sinP);
	fwd.SetZ(cosP*-cosY);

	m_Target=fwd+m_Position;


	m_Up.SetX((-cosY*sinR)-(sinY*sinP*cosR));
	m_Up.SetY(cosP*cosR);
	m_Up.SetZ((-sinY*sinR)-(sinP*cosR*-cosY));

	gluLookAt(m_Position.GetX(),m_Position.GetY(),m_Position.GetZ()
		,m_Target.GetX(),m_Target.GetY(),m_Target.GetZ()
		,m_Up.GetX(),m_Up.GetY(),m_Up.GetZ());

	m_Position=m_Position+((m_Target-m_Position)*m_speed);
	//DrawCameraInfo();
UnGuard
}

void ExCCameraFlight::Process(void)
{
Guard(void ExCCameraFlight::Process(void))
	bool	rotate=false;
	for(unsigned i=0;i<m_VecAction.size();i++)
	{
		switch(m_VecAction.at(i)) 
		{
		case ROTATE_Z_UP:;break;
		case ROTATE_Y_UP:m_Angle.IncY();m_Angle.DecZ();rotate=true;break;
		case ROTATE_X_UP:m_Angle.IncX();break;
		case ROTATE_Z_DOWN:break;
		case ROTATE_Y_DOWN:m_Angle.DecY();m_Angle.IncZ();rotate=true;break;
		case ROTATE_X_DOWN:m_Angle.DecX();break;
		case ZOOM_UP:ZoomOut();break;
		case ZOOM_DOWN:ZoomIn();break;
		case SPEED_UP:break;
		case SPEED_DOWN:break;
		}
	}
	//nothing happen angle z go to zero
	if(!rotate)
	{
		if (m_Angle.GetZ()>0&&m_Angle.GetZ()<180&&m_Angle.GetZ()!=0) {m_Angle.DecZ();}
		if (m_Angle.GetZ()>180&&m_Angle.GetZ()<359&&m_Angle.GetZ()!=0) {m_Angle.IncZ();}
	}
UnGuard
}