/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/* Benjamin Michotte Linux port, webmaster                              */
/*                                                                      */
/* Mail             :binny@ploksoftware.org                             */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCHeightMap.h											*/
/*																		*/
/* Star Date   :04/07/2003												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXCHEIGHTMAP_H__
#define __EXCHEIGHTMAP_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerTexture.h"
//------------------------------------------------------------------------
#include "Manager/ExManagerFog.h"
//------------------------------------------------------------------------
#include "Object/Object3D/ExCObject3D.h"
//------------------------------------------------------------------------
class ExCHeightMap :public ExCObject3D
{
protected:
//--------------------------------
// Variable
//--------------------------------
	ExManagerTexture		*ManagerTexture;
	ExManagerFog			*ManagerFog;
	
	BYTE					*g_HeightMap;	
	
	float					g_DetailScale;
	std::string				m_TextureMap;

	int						m_MapDetailLevel;
	int						m_MapResolution;
	
	float					m_MapScale;
	
	bool					m_Fog;
	float					m_FogDepthLevel;

	float					m_Texture2Repetition;

	std::vector<std::string>	m_VecTexture;
	void SetTextureCoord(float CoordU,float CoordV);

	float	*TabVertices;
	float	*TabTextures;

	void BuildArray(void);

	bool m_Array;

	void RenderArray(void);
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExCHeightMap(void);
	~ExCHeightMap(void);
//--------------------------------
// Methode
//--------------------------------
	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture=Texture;}
	inline void SetManagerFog(ExManagerFog * Fog){ManagerFog=Fog;}
//--------------------------------
	void Draw(void);
	void Load(std::string FileName);
	void RenderHeightMap(void);	

	inline void SetTextureMap(std::string FileName){m_TextureMap=FileName;}
	void  SetTextureLand(unsigned int Number,std::string FileName);
	//inline void SetTextureLand2(std::string FileName){m_TextureLand2=FileName;}
	
	
	inline void SetMapResolution(int Resolution){m_MapResolution=Resolution;}
	inline void SetMapDetailLevel(int level){m_MapDetailLevel=level;}
	void IncreaseDetailLevel(void);
	void DereaseDetailLevel(void);
	inline void SetFogState(bool state){m_Fog=state;}
	inline bool GetFogState(void){return m_Fog;}

	inline void SetFogDepthLevel(float level){m_FogDepthLevel=level;}
	void IncreaseFogDepthLevel(void);
	void DereaseFogDepthLevel(void);

	inline void SetTexture2Repetition(float level){m_Texture2Repetition=level;}
	void IncreaseTexture2Repetition(void);
	void DereaseTexture2Repetition(void);


	// This returns the height (0 to 255) from a heightmap given an X and Y
	int Height(int X, int Y);


	
};
//------------------------------------------------------------------------
#endif //__EXMAP_H__
