/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 * $Id: ExCLight.cpp,v 1.8 2002/08/14 15:40:05 data Exp $
 *
 */

#include "ExCLight.h"

ExCLight::ExCLight()
{
Guard(ExCLight::ExCLight())
	Reset();
	m_LightNumber=0;
	SetName("ExCLight");
	SetType(typeid(this).name());
UnGuard
}

ExCLight::ExCLight(GLenum Number)
{
Guard(ExCLight::ExCLight(GLenum Number))
	Reset();
	m_LightNumber=Number;
UnGuard
}

ExCLight::~ExCLight(void)
{
Guard(ExCLight::~ExCLight(void))
UnGuard
}

void ExCLight::Reset(void)
{
Guard(ExCLight::Reset(void))
	TurnOn();
	glEnable(GL_LIGHT0);	
	m_Angle.SetValue(0,0,0);
	m_State=false;
	SetAmbiant(0.0f,0.0f,0.0f,1.0f);
	SetDiffuse(1.0f,1.0f,1.0f,1.0f);
	SetSpecular(1.0f,1.0f,1.0f,1.0f);
	m_Position.SetValue(10,10,0);
	m_Target.SetValue(0,0,0);
	SetSpotExponent(0.0f);
	SetSpotCutOff(180.0f);
	SetConstantAttenuation(1.0f);
	SetLinearAttenuation(0.0f);
	SetQuadraticAttenuation(0.0f);
	
UnGuard
}

void ExCLight::SetLightNumber(GLenum light)
{
Guard(void ExCLight::SetLightNumber(GLenum light))
	m_LightNumber=light;	
UnGuard
}

void ExCLight::TurnOn(void)
{
Guard(void ExCLight::TurnOn(void))
	m_State=true;
	glEnable(m_LightNumber);
UnGuard
}

void ExCLight::TurnOff(void)
{
Guard(void ExCLight::TurnOff(void))
	m_State=false;
	glDisable(m_LightNumber);
UnGuard
}

void ExCLight::SetAmbiant(float R,float G,float B,float A)
{
Guard(void ExCLight::SetAmbiant(float R,float G,float B,float A))
	SetAmbiantR(R);
	SetAmbiantG(G);
	SetAmbiantB(B);
	SetAmbiantA(A);
UnGuard
}

void ExCLight::SetAmbiantR(float R)
{
Guard(void ExCLight::SetAmbiantR(float R))
	if(R>1)R=1.0f;if(R<0.0f)R=0.0f;
	m_ambiant[0]=R;
	glLightfv(m_LightNumber,GL_AMBIENT,m_ambiant);
UnGuard
}

void ExCLight::SetAmbiantG(float G)
{
Guard(void ExCLight::SetAmbiantG(float G))
	if(G>1)G=1.0f;if(G<0.0f)G=0.0f;	
	m_ambiant[1]=G;
	glLightfv(m_LightNumber,GL_AMBIENT,m_ambiant);
UnGuard
}

void ExCLight::SetAmbiantB(float B)
{
Guard(void ExCLight::SetAmbiantB(float B))
	if(B>1)B=1.0f;if(B<0.0f)B=0.0f;
	m_ambiant[2]=B;
	glLightfv(m_LightNumber,GL_AMBIENT,m_ambiant);
UnGuard
}

void ExCLight::SetAmbiantA(float A)
{
Guard(void ExCLight::SetAmbiantA(float A))
	if(A>1)A=1.0f;if(A<0.0f)A=0.0f;
	m_ambiant[3]=A;
	glLightfv(m_LightNumber,GL_AMBIENT,m_ambiant);
UnGuard
}

float ExCLight::GetAmbiantR(void)
{
Guard(float ExCLight::GetAmbiantR(void))
	return m_ambiant[0];
UnGuard
}

float ExCLight::GetAmbiantG(void)
{
Guard(float ExCLight::GetAmbiantG(void))
	return m_ambiant[1];
UnGuard
}

float ExCLight::GetAmbiantB(void)
{
Guard(float ExCLight::GetAmbiantB(void))
	return m_ambiant[2];
UnGuard
}

float ExCLight::GetAmbiantA(void)
{
Guard(float ExCLight::GetAmbiantA(void))
	return m_ambiant[3];
UnGuard
}

void ExCLight::IncAmbiantR(float inc)
{
Guard(void ExCLight::IncAmbiantR(float inc))
	SetAmbiantR(GetAmbiantR()+inc);
UnGuard
}

void ExCLight::IncAmbiantG(float inc)
{
Guard(void ExCLight::IncAmbiantG(float inc))
	SetAmbiantG(GetAmbiantG()+inc);
UnGuard
}

void ExCLight::IncAmbiantB(float inc)
{
Guard(void ExCLight::IncAmbiantB(float inc))
	SetAmbiantB(GetAmbiantB()+inc);
UnGuard
}

void ExCLight::IncAmbiantA(float inc)
{
Guard(void ExCLight::IncAmbiantA(float inc))
	SetAmbiantA(GetAmbiantA()+inc);
UnGuard
}

void ExCLight::SetDiffuse(float R,float G,float B,float A)
{
Guard(void ExCLight::SetDiffuse(float R,float G,float B,float A))
	SetDiffuseR(R);
	SetDiffuseG(G);
	SetDiffuseB(B);
	SetDiffuseA(A);
UnGuard
}

void ExCLight::SetDiffuseR(float R)
{
Guard(void ExCLight::SetDiffuseR(float R))
	if(R>1)R=1.0f;if(R<0.0f)R=0.0f;
	m_diffuse[0]=R;
	glLightfv(m_LightNumber,GL_DIFFUSE,m_diffuse);
UnGuard
}

void ExCLight::SetDiffuseG(float G)
{
Guard(void ExCLight::SetDiffuseG(float G))
	if(G>1)G=1.0f;if(G<0.0f)G=0.0f;	
	m_diffuse[1]=G;
	glLightfv(m_LightNumber,GL_DIFFUSE,m_diffuse);
UnGuard
}

void ExCLight::SetDiffuseB(float B)
{
Guard(void ExCLight::SetDiffuseB(float B))
	if(B>1)B=1.0f;if(B<0.0f)B=0.0f;
	m_diffuse[2]=B;
	glLightfv(m_LightNumber,GL_DIFFUSE,m_diffuse);
UnGuard
}

void ExCLight::SetDiffuseA(float A)
{
Guard(void ExCLight::SetDiffuseA(float A))
	if(A>1)A=1.0f;if(A<0.0f)A=0.0f;
	m_diffuse[3]=A;
	glLightfv(m_LightNumber,GL_DIFFUSE,m_diffuse);
UnGuard
}

float ExCLight::GetDiffuseR(void)
{
Guard(float ExCLight::GetDiffuseR(void))
	return m_diffuse[0];
UnGuard
}

float ExCLight::GetDiffuseG(void)
{
Guard(float ExCLight::GetDiffuseG(void))
	return m_diffuse[1];
UnGuard
}

float ExCLight::GetDiffuseB(void)
{
Guard(float ExCLight::GetDiffuseB(void))
	return m_diffuse[2];
UnGuard
}

float ExCLight::GetDiffuseA(void)
{
Guard(float ExCLight::GetDiffuseA(void))
	return m_diffuse[3];
UnGuard
}

void ExCLight::IncDiffuseR(float inc)
{
Guard(void ExCLight::IncDiffuseR(float inc))
	SetDiffuseR(GetDiffuseR()+inc);
UnGuard
}

void ExCLight::IncDiffuseG(float inc)
{
Guard(void ExCLight::IncDiffuseG(float inc))
	SetDiffuseG(GetDiffuseG()+inc);
UnGuard
}

void ExCLight::IncDiffuseB(float inc)
{
Guard(void ExCLight::IncDiffuseB(float inc))
	SetDiffuseB(GetDiffuseB()+inc);
UnGuard
}

void ExCLight::IncDiffuseA(float inc)
{
Guard(void ExCLight::IncDiffuseA(float inc))
	SetDiffuseA(GetDiffuseA()+inc);
UnGuard
}

void ExCLight::SetSpecular(float R,float G,float B,float A)
{
Guard(void ExCLight::SetSpecular(float R,float G,float B,float A))
	SetSpecularR(R);
	SetSpecularG(G);
	SetSpecularB(B);
	SetSpecularA(A);
UnGuard
}

void ExCLight::SetSpecularR(float R)
{
Guard(void ExCLight::SetSpecularR(float R))
	if(R>1)R=1.0f;if(R<0.0f)R=0.0f;
	m_specular[0]=R;
	glLightfv(m_LightNumber,GL_SPECULAR,m_specular);
UnGuard
}

void ExCLight::SetSpecularG(float G)
{
Guard(void ExCLight::SetSpecularG(float G))
	if(G>1)G=1.0f;if(G<0.0f)G=0.0f;	
	m_specular[1]=G;
	glLightfv(m_LightNumber,GL_SPECULAR,m_specular);
UnGuard
}

void ExCLight::SetSpecularB(float B)
{
Guard(void ExCLight::SetSpecularB(float B))
	if(B>1)B=1.0f;if(B<0.0f)B=0.0f;
	m_specular[2]=B;
	glLightfv(m_LightNumber,GL_SPECULAR,m_specular);
UnGuard
}

void ExCLight::SetSpecularA(float A)
{
Guard(void ExCLight::SetSpecularA(float A))
	if(A>1)A=1.0f;if(A<0.0f)A=0.0f;
	m_specular[3]=A;
	glLightfv(m_LightNumber,GL_SPECULAR,m_specular);
UnGuard
}

float ExCLight::GetSpecularR(void)
{
Guard(float ExCLight::GetSpecularR(void))
	return m_specular[0];
UnGuard
}

float ExCLight::GetSpecularG(void)
{
Guard(float ExCLight::GetSpecularG(void))
	return m_specular[1];
UnGuard
}

float ExCLight::GetSpecularB(void)
{
Guard(float ExCLight::GetSpecularB(void))
	return m_specular[2];
UnGuard
}

float ExCLight::GetSpecularA(void)
{
Guard(float ExCLight::GetSpecularA(void))
	return m_specular[3];
UnGuard
}

void ExCLight::IncSpecularR(float inc)
{
Guard(void ExCLight::IncSpecularR(float inc))
	SetSpecularR(GetSpecularR()+inc);
UnGuard
}

void ExCLight::IncSpecularG(float inc)
{
Guard(void ExCLight::IncSpecularG(float inc))
	SetSpecularG(GetSpecularG()+inc);
UnGuard
}

void ExCLight::IncSpecularB(float inc)
{
Guard(void ExCLight::IncSpecularB(float inc))
	SetSpecularB(GetSpecularB()+inc);
UnGuard
}

void ExCLight::IncSpecularA(float inc)
{
Guard(void ExCLight::IncSpecularA(float inc))
	SetSpecularA(GetSpecularA()+inc);
UnGuard
}


void ExCLight::SetPosition(double X,double Y,double Z)
{
Guard(void ExCLight::SetPosition(double X,double Y,double Z))
	SetPosition(X,Y,Z);
	GLfloat lightPos[] = { m_Position.GetX(), m_Position.GetY(),m_Position.GetZ()};
	glLightfv(m_LightNumber, GL_POSITION, lightPos );
UnGuard
}

void ExCLight::SetPositionX(double X)
{
Guard(void ExCLight::SetPositionX(double X))
	m_Position.SetX(X);
	GLfloat lightPos[] = { m_Position.GetX(), m_Position.GetY(),m_Position.GetZ()};
	glLightfv(m_LightNumber, GL_POSITION, lightPos );
UnGuard
}

void ExCLight::SetPositionY(double Y)
{
Guard(void ExCLight::SetPositionY(double Y))
	m_Position.SetY(Y);
	GLfloat lightPos[] = { m_Position.GetX(), m_Position.GetY(),m_Position.GetZ()};
	glLightfv(m_LightNumber, GL_POSITION, lightPos );
UnGuard
}

void ExCLight::SetPositionZ(double Z)
{
Guard(void ExCLight::SetPositionZ(double Z))
	m_Position.SetZ(Z);
	GLfloat lightPos[] = { m_Position.GetX(), m_Position.GetY(),m_Position.GetZ()};
	glLightfv(m_LightNumber, GL_POSITION, lightPos );
UnGuard
}


void ExCLight::SetTargetX(double X)
{
Guard(void ExCLight::SetTargetX(double X))
	m_Target.SetX(X);
	GLfloat lightPos[] = { m_Target.GetX(), m_Target.GetY(),m_Target.GetZ(), 1.0 };
	glLightfv(m_LightNumber, GL_POSITION, lightPos );
UnGuard
}

void ExCLight::SetTargetY(double Y)
{
Guard(void ExCLight::SetTargetY(double Y))
	m_Target.SetY(Y);
	GLfloat lightPos[] = { m_Target.GetX(), m_Target.GetY(),m_Target.GetZ(), 1.0 };
	glLightfv(m_LightNumber, GL_POSITION, lightPos );
UnGuard
}

void ExCLight::SetTargetZ(double Z)
{
Guard(void ExCLight::SetTargetZ(double Z))
	m_Target.SetZ(Z);
	GLfloat lightPos[] = { m_Target.GetX(), m_Target.GetY(),m_Target.GetZ(), 1.0 };
	glLightfv(m_LightNumber, GL_POSITION, lightPos );
UnGuard
}




void ExCLight::SetTarget(double X,double Y,double Z)
{
Guard(void ExCLight::SetTarget(double X,double Y,double Z))
	//SetTarget(X,Y,Z);
	GLfloat lightPos[] = { m_Target.GetX(), m_Target.GetY(),m_Target.GetZ(), 1.0 };
	glLightfv(m_LightNumber,GL_SPOT_DIRECTION,lightPos);
UnGuard
}

void ExCLight::SetSpotExponent(float Exponent)
{
Guard(void ExCLight::SetSpotExponent(float Exponent))
	if(Exponent<0)Exponent=0.0f;if(Exponent>128)Exponent=128.0f;
	m_spotExponent[0]=Exponent;
	glLightfv(m_LightNumber,GL_SPOT_EXPONENT,m_spotExponent);
UnGuard
}

void ExCLight::IncSpotExponent(float inc)
{
Guard(void ExCLight::IncSpotExponent(float inc))
	SetSpotExponent(GetSpotExponent()+inc);
UnGuard
}

float ExCLight::GetSpotExponent(void)
{
Guard(float ExCLight::GetSpotExponent(void))
	return m_spotExponent[0];
UnGuard
}

void ExCLight::SetSpotCutOff(float cut)
{
Guard(void ExCLight::SetSpotCutOff(float cut))
	if(cut>m_spotCutOff[0])
	{
		if(cut>90)cut=180;
	}else
	{
		if(cut<0)cut=0;
		if(cut>90)cut=90;
		
	}

	m_spotCutOff[0]=cut;
	glLightfv(m_LightNumber,GL_SPOT_CUTOFF,m_spotCutOff);
UnGuard
}

void ExCLight::IncSpotCutOff(float inc)
{
Guard(void ExCLight::IncSpotCutOff(float inc))
	SetSpotCutOff(GetSpotCutOff()+inc);
UnGuard
}

float ExCLight::GetSpotCutOff(void)
{
Guard(float ExCLight::GetSpotCutOff(void))
	return m_spotCutOff[0];
UnGuard
}

void ExCLight::SetConstantAttenuation(float att)
{
Guard(void ExCLight::SetConstantAttenuation(float att))
	if(att<0)att=0.0f;if(att>5)att=5.0f;
	m_spotConstentAtt[0]=att;
	glLightfv(m_LightNumber,GL_CONSTANT_ATTENUATION,m_spotConstentAtt);
UnGuard
}

void ExCLight::IncConstantAttenuation(float inc)
{
Guard(void ExCLight::IncConstantAttenuation(float inc))
	SetConstantAttenuation(GetConstantAttenuation()+inc);
UnGuard
}

float ExCLight::GetConstantAttenuation(void)
{
Guard(float ExCLight::GetConstantAttenuation(void))
	return m_spotConstentAtt[0];
UnGuard
}

void ExCLight::SetLinearAttenuation(float att)
{
Guard(void ExCLight::SetLinearAttenuation(float att))
	if(att<0)att=0.0f;if(att>5)att=5.0f;
	m_spotLinearAtt[0]=att;
	glLightfv(m_LightNumber,GL_LINEAR_ATTENUATION,m_spotLinearAtt);
UnGuard
}

void ExCLight::IncLinearAttenuation(float inc)
{
Guard(void ExCLight::IncLinearAttenuation(float inc))
	SetLinearAttenuation(GetLinearAttenuation()+inc);
UnGuard
}

float ExCLight::GetLinearAttenuation(void)
{
Guard(float ExCLight::GetLinearAttenuation(void))
	return m_spotLinearAtt[0];
UnGuard
}

void ExCLight::SetQuadraticAttenuation(float att)
{
Guard(void ExCLight::SetQuadraticAttenuation(float att))
	if(att<0)att=0.0f;if(att>5)att=5.0f;
	m_spotQuadraticAtt[1]=att;
	glLightfv(m_LightNumber,GL_QUADRATIC_ATTENUATION,m_spotQuadraticAtt);
UnGuard
}

void ExCLight::IncQuadraticAttenuation(float inc)
{
Guard(void ExCLight::IncQuadraticAttenuation(float inc))
	SetQuadraticAttenuation(GetQuadraticAttenuation()+inc);
UnGuard
}

float ExCLight::GetQuadraticAttenuation(void)
{
Guard(float ExCLight::GetQuadraticAttenuation(void))
	return m_spotQuadraticAtt[1];
UnGuard
}

void ExCLight::Draw(void)
{
Guard(void ExCLight::Draw(void))
	glPushMatrix();
	glDisable(GL_LIGHTING);
		glColor3f(1,1,1);
		glTranslatef(m_Position.GetX(),m_Position.GetY(),m_Position.GetZ());
		glutWireSphere(0.5,10,10);
	glPopMatrix();
UnGuard
}

