/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCObject3D.h											*/
/*																		*/
/* Start Date   :06/20/2003												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXOBJECT3D_H__
#define __EXOBJECT3D_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Object/ExCObject.h"
//------------------------------------------------------------------------
class ExCObject3D : public ExCObject  
{
protected:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExCVec3D			m_Up;
	ExCVec3D			m_Velocity;
	ExCVec3D			m_Gravity;

	ExCVec3D				m_Acceleration;
	double				m_RefreshTime;

	double				m_Life;
	double				m_StartingLife;
    float				m_Size;
	float				m_Mass;
	bool				m_ShowInfo;
	bool				m_CurrentObject;

public:
	ExCVec3D			m_Position;
	ExCVec3D			m_OldPosition;
	ExCVec3D			m_Target;
	ExCVec3D			m_OldTarget;
	ExCVec3D			m_Angle;
	//float		m_AngleX;
	//float		m_AngleY;
	//float		m_AngleZ;
	int					m_speed;
	float				m_SphereRadius;
	bool				m_Visible;
//------------------------------------------------------------------------
// Constructor // Destructor
//------------------------------------------------------------------------
	ExCObject3D();
	virtual ~ExCObject3D();
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	void SetCurrentState(bool state){m_CurrentObject=state;}
//------------------------------------------------------------------------
	void ShowInfo(void);
	inline void SetShowInfoState(bool state){m_ShowInfo=state;}
	inline bool GetShowInfoState(void){return m_ShowInfo;}
//------------------------------------------------------------------------
	void SetAngleX(float Angle);
	void SetAngleY(float Angle);
	void SetAngleZ(float Angle);
	inline float GetAngleX(void){return m_Angle.GetX();}
	inline float GetAngleY(void){return m_Angle.GetY();}
	inline float GetAngleZ(void){return m_Angle.GetZ();}
//------------------------------------------------------------------------
	inline void		SetAcceleration(ExCVec3D Acceleration) {m_Acceleration=Acceleration;}
	inline void		SetAcceleration(float x,float y,float z){m_Acceleration=ExCVec3D(x,y,z);}
	inline ExCVec3D	GetAcceleration(void)	{return m_Acceleration;}
//------------------------------------------------------------------------
	inline void		SetVelocity(ExCVec3D Velocity) {m_Velocity=Velocity;}
	inline void		SetVelocity(float x,float y,float z){m_Velocity=ExCVec3D(x,y,z);}
	inline ExCVec3D	GetVelocity(void)	{return m_Velocity;}
//------------------------------------------------------------------------
	inline void		SetGravity(ExCVec3D Gravity){m_Gravity=Gravity;}
	inline void		SetGravity(float x,float y,float z){m_Gravity=ExCVec3D(x,y,z);}
	inline ExCVec3D	GetGravity(void)	{return m_Gravity;}
//------------------------------------------------------------------------
	inline void		SetPosition(ExCVec3D Position){m_Position=Position;}
	inline void		SetPosition(float x,float y,float z){m_Position=ExCVec3D(x,y,z);}
	inline ExCVec3D	GetPosition(void)	{return m_Position;}
//------------------------------------------------------------------------
	inline void		SetTarget(ExCVec3D Target){m_Target=Target;}
	inline void		SetTarget(float x,float y,float z){m_Target=ExCVec3D(x,y,z);}
	inline ExCVec3D	GetTarget(void)	{return m_Target;}
//------------------------------------------------------------------------
	inline void		SetOldPosition(ExCVec3D OldPosition){m_OldPosition=OldPosition;}
	inline void		SetOldPosition(float x,float y,float z){m_OldPosition=ExCVec3D(x,y,z);}
	inline ExCVec3D	GetOldPosition(void)	{return m_OldPosition;}
//------------------------------------------------------------------------
	inline void		SetOldTarget(ExCVec3D OldTarget){m_OldTarget=OldTarget;}
	inline void		SetOldTarget(float x,float y,float z){m_OldTarget=ExCVec3D(x,y,z);}
	inline ExCVec3D	GetOldTarget(void)	{return m_OldTarget;}
//------------------------------------------------------------------------
	void Rotate(float angleX,float angleY,float angleZ);
	void Rotate(void);
//------------------------------------------------------------------------
	inline void SetVisibleState(bool state){m_Visible=state;}
	inline bool GetVisibleState(void){return m_Visible;}
};
//------------------------------------------------------------------------
#endif // __EXOBJECT3D_H__
