/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 
 
 *
 */

#include "ExCSkyBox.h"

ExCSkyBox::ExCSkyBox(void)
{
		m_Size=1000;
	
}

ExCSkyBox::~ExCSkyBox(void)
{
}

void ExCSkyBox::BuildBox(void)
{
Guard(void ExCSkyBox::BuildBox(void))
	m_TabVertices= new float[72];
	m_TabTextures= new float[48];
	

	// Front Face
	int i=0,j=0;
	m_TabVertices[i+0]=-1;m_TabVertices[i+1]= 1;m_TabVertices[i+2]= 1;
	m_TabVertices[i+3]= 1;m_TabVertices[i+4]= 1;m_TabVertices[i+5]= 1;
	m_TabVertices[i+6]= 1;m_TabVertices[i+7]=-1;m_TabVertices[i+8]= 1;
	m_TabVertices[i+9]=-1;m_TabVertices[i+10]=-1;m_TabVertices[i+11]= 1;
	 
	m_TabTextures[j+0]=1.0f;m_TabTextures[j+1]=1.0f;
	m_TabTextures[j+2]=0.0f;m_TabTextures[j+3]=1.0f;
	m_TabTextures[j+4]=0.0f;m_TabTextures[j+5]=0.0f;
	m_TabTextures[j+6]=1.0f;m_TabTextures[j+7]=0.0f;

	// Back Face
	i=12,j=8;
	m_TabVertices[i+0]= 1;m_TabVertices[i+1]=-1;m_TabVertices[i+2]= -1;
	m_TabVertices[i+3]= 1;m_TabVertices[i+4]= 1;m_TabVertices[i+5]= -1;
	m_TabVertices[i+6]=-1;m_TabVertices[i+7]= 1;m_TabVertices[i+8]= -1;
	m_TabVertices[i+9]=-1;m_TabVertices[i+10]=-1;m_TabVertices[i+11]= -1;

	m_TabTextures[j+0]=1.0f;m_TabTextures[j+1]=0.0f;
	m_TabTextures[j+2]=1.0f;m_TabTextures[j+3]=1.0f;
	m_TabTextures[j+4]=0.0f;m_TabTextures[j+5]=1.0f;
	m_TabTextures[j+6]=0.0f;m_TabTextures[j+7]=0.0f;
	// Top Face
	i=24,j=16;
	m_TabVertices[i+0]= 1;m_TabVertices[i+1]= 1;m_TabVertices[i+2]= -1;
	m_TabVertices[i+3]= 1;m_TabVertices[i+4]= 1;m_TabVertices[i+5]= 1;
	m_TabVertices[i+6]=-1;m_TabVertices[i+7]= 1;m_TabVertices[i+8]= 1;
	m_TabVertices[i+9]=-1;m_TabVertices[i+10]= 1;m_TabVertices[i+11]= -1;

	m_TabTextures[j+0]=1.0f;m_TabTextures[j+1]=0.0f;
	m_TabTextures[j+2]=1.0f;m_TabTextures[j+3]=1.0f;
	m_TabTextures[j+4]=0.0f;m_TabTextures[j+5]=1.0f;
	m_TabTextures[j+6]=0.0f;m_TabTextures[j+7]=0.0f;
	// Bottom Face
	i=36,j=24;
	m_TabVertices[i+0]=-1;m_TabVertices[i+1]=-1;m_TabVertices[i+2]= 1;
	m_TabVertices[i+3]= 1;m_TabVertices[i+4]=-1;m_TabVertices[i+5]= 1;
	m_TabVertices[i+6]= 1;m_TabVertices[i+7]=-1;m_TabVertices[i+8]= -1;
	m_TabVertices[i+9]=-1;m_TabVertices[i+10]=-1;m_TabVertices[i+11]= -1;

	m_TabTextures[j+0]=0.0f;m_TabTextures[j+1]=0.0f;
	m_TabTextures[j+2]=1.0f;m_TabTextures[j+3]=0.0f;
	m_TabTextures[j+4]=1.0f;m_TabTextures[j+5]=1.0f;
	m_TabTextures[j+6]=0.0f;m_TabTextures[j+7]=1.0f;
	// Right face
	i=48,j=32;
	m_TabVertices[i+0]= 1;m_TabVertices[i+1]=-1;m_TabVertices[i+2]= 1;
	m_TabVertices[i+3]= 1;m_TabVertices[i+4]= 1;m_TabVertices[i+5]= 1;
	m_TabVertices[i+6]= 1;m_TabVertices[i+7]= 1;m_TabVertices[i+8]= -1;
	m_TabVertices[i+9]= 1;m_TabVertices[i+10]=-1;m_TabVertices[i+11]= -1;

	m_TabTextures[j+0]=1.0f;m_TabTextures[j+1]=0.0f;
	m_TabTextures[j+2]=1.0f;m_TabTextures[j+3]=1.0f;
	m_TabTextures[j+4]=0.0f;m_TabTextures[j+5]=1.0f;
	m_TabTextures[j+6]=0.0f;m_TabTextures[j+7]=0.0f;
	// Left Face
	i=60,j=40;
	m_TabVertices[i+0]=-1;m_TabVertices[i+1]= 1;m_TabVertices[i+2]= -1;
	m_TabVertices[i+3]=-1;m_TabVertices[i+4]= 1;m_TabVertices[i+5]= 1;
	m_TabVertices[i+6]=-1;m_TabVertices[i+7]=-1;m_TabVertices[i+8]= 1;
	m_TabVertices[i+9]=-1;m_TabVertices[i+10]=-1;m_TabVertices[i+11]= -1;

	m_TabTextures[j+0]=1.0f;m_TabTextures[j+1]=1.0f;
	m_TabTextures[j+2]=0.0f;m_TabTextures[j+3]=1.0f;
	m_TabTextures[j+4]=0.0f;m_TabTextures[j+5]=0.0f;
	m_TabTextures[j+6]=1.0f;m_TabTextures[j+7]=0.0f;
UnGuard
}

void ExCSkyBox::Load(std::string FileName)
{
Guard(void ExCSkyBox::Load(std::string FileName))
	BuildBox();
	char			buffer[255],b[255];	
	std::string buffstring;
	std::ifstream file;

	#ifdef UNIX_SRC
	sprintf(buffer, PREFIX "/ExNihilo/Data/Map/%s", FileName.data());
	#else
	sprintf(buffer, "../Data/Map/%s", FileName.data());
	#endif
	file.open(buffer,std::ios::in);
	if(file.is_open())
	{
		
		try
		{
			
			memset(b,0,255);file.getline(b,256,'\n');//pass comment line
			memset(b,0,255);file.getline(b,256,'\n');
			m_SkyBox.m_Size=ExNihilo::ExtractFloatValueFromSring(b,"<Size>","<#Size>");
			for(int j=0;j<4;j++)
			{
				memset(b,0,255);file.getline(b,256,'\n');//pass comment line
				memset(b,0,255);file.getline(b,256,'\n');
				m_SkyBox.m_Texture[j][SKY_TOP]=ExNihilo::ExtracValueFromSring(b,"<Texture_top>","<#Texture_top>");
				ManagerTexture->SetCurrentObject(m_SkyBox.m_Texture[j][SKY_TOP]);
				glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
				glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
				memset(b,0,255);file.getline(b,256,'\n');
				m_SkyBox.m_Texture[j][SKY_BOTTOM]=ExNihilo::ExtracValueFromSring(b,"<Texture_bottom>","<#Texture_bottom>");
				ManagerTexture->SetCurrentObject(m_SkyBox.m_Texture[j][SKY_BOTTOM]);
				glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
				glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
				memset(b,0,255);file.getline(b,256,'\n');
				m_SkyBox.m_Texture[j][SKY_FRONT]=ExNihilo::ExtracValueFromSring(b,"<Texture_front>","<#Texture_front>");
				ManagerTexture->SetCurrentObject(m_SkyBox.m_Texture[j][SKY_FRONT]);
				glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
				glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
				memset(b,0,255);file.getline(b,256,'\n');
				m_SkyBox.m_Texture[j][SKY_BACK]=ExNihilo::ExtracValueFromSring(b,"<Texture_back>","<#Texture_back>");
				ManagerTexture->SetCurrentObject(m_SkyBox.m_Texture[j][SKY_BACK]);
				glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
				glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
				memset(b,0,255);file.getline(b,256,'\n');
				m_SkyBox.m_Texture[j][SKY_LEFT]=ExNihilo::ExtracValueFromSring(b,"<Texture_left>","<#Texture_left>");
				ManagerTexture->SetCurrentObject(m_SkyBox.m_Texture[j][SKY_LEFT]);
				glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
				glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
				memset(b,0,255);file.getline(b,256,'\n');
				m_SkyBox.m_Texture[j][SKY_RIGHT]=ExNihilo::ExtracValueFromSring(b,"<Texture_right>","<#Texture_right>");
				ManagerTexture->SetCurrentObject(m_SkyBox.m_Texture[j][SKY_RIGHT]);
				glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_CLAMP);
				glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_CLAMP);
			
			}

		}catch(ExCExpStringNotFound){std::cout<<"Bad file type "<<buffer<<std::endl;}
	}else
	{
		std::cout<<"File not found:"<<buffer<<std::endl;
		throw   ExCExpFileNotFound();
	}
	
UnGuard
}


void ExCSkyBox::Draw(void)
{
Guard(void ExCSkyBox::Draw(void))
	glPushAttrib(GL_ALL_ATTRIB_BITS);
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);
		glColor3f(1.0f,1.0f,1.0f);
		glPushMatrix();
			glTranslatef(0,4000,0);
			glScalef(m_SkyBox.m_Size,m_SkyBox.m_Size,m_SkyBox.m_Size);
			for(int i=0;i<6;i++)
			{
				ManagerTexture->SetTexture(3,m_SkyBox.m_Texture[3][i]);
				glTexCoordPointer(2,GL_FLOAT,0,m_TabTextures);
				ManagerTexture->SetTexture(2,m_SkyBox.m_Texture[2][i]);
				glTexCoordPointer(2,GL_FLOAT,0,m_TabTextures);
				ManagerTexture->SetTexture(1,m_SkyBox.m_Texture[1][i]);
				glTexCoordPointer(2,GL_FLOAT,0,m_TabTextures);
				ManagerTexture->SetTexture(0,m_SkyBox.m_Texture[0][i]);
				glTexCoordPointer(2,GL_FLOAT,0,m_TabTextures);
				glVertexPointer(3,GL_FLOAT,0,m_TabVertices);
				glDrawArrays( GL_QUADS, 0+(i*4), 4 );
				ManagerTexture->ResetMultitexture();
			}
		glPopMatrix();
	glPopAttrib();
UnGuard
}



