/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCSkyBox.h												*/
/*																		*/
/* Star Date   :04/07/2003												*/
/*																		*/
/* Last Update :  06/20/2003                                            */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef _EXCSKYBOX_H__
#define _EXCSKYBOX_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Object/Object3D/ExCObject3D.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerTexture.h"
//------------------------------------------------------------------------
//Define
//------------------------------------------------------------------------
#define SKY_BACK		0
#define SKY_FRONT		1
#define SKY_TOP			2
#define SKY_BOTTOM		3
#define SKY_LEFT		4
#define SKY_RIGHT		5

struct SkyBox 
{
	std::string				m_Texture[4][6];
	float					m_Size;
};

class ExCSkyBox :public ExCObject3D
{
protected:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExManagerTexture		*ManagerTexture;
	float					*m_TabTextures;
	float					*m_TabVertices;
	SkyBox					m_SkyBox;
	void BuildBox(void);
public:
//------------------------------------------------------------------------
// Constructor // Destructor
//------------------------------------------------------------------------
	ExCSkyBox(void);
	~ExCSkyBox(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture=Texture;}
	void Draw(void);
	void Load(std::string FileName);
};
//------------------------------------------------------------------------
#endif //_EXCSKYBOX_H__
