/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 

 *
 */

#include "ExCMesh3ds.h"

ExCMesh3ds::ExCMesh3ds()
{
Guard(ExCMesh3ds::ExCMesh3ds())
	SetName("ExCMesh3ds");
	SetType(typeid(this).name());
	m_CurrentAnimation=0;
	m_TimeForNextFrame=100;
	m_InterpolationPourcentage=10;
	m_CurrentInterpolation=0;
	m_HasInterpolation=false;
UnGuard
}

ExCMesh3ds::~ExCMesh3ds()
{
Guard(ExCMesh3ds::~ExCMesh3ds())
UnGuard
}


void ExCMesh3ds::Draw(void)
{
Guard(void ExCMesh3ds::Draw(void))

/*	
	//copy data
	for(unsigned int i=0;i<Current3ds->m_VecObject->size();i++)
	{
		t3DObject Tmpt3dobj;
		//get object data
		Tmpt3dobj=Current3ds->m_VecObject->at(i);
		//std::cout<<"copy object:"<<Current3ds->m_VecObject->at(i).Material<<std::endl;
		//std::cout<<"test copy object:"<<Tmpt3dobj.Material<<std::endl;
		//modify objet data

		for(unsigned int j;j<Tmpt3dobj.Verts.size();j++)
		{
			Tmpt3dobj.Verts.at(j)=Current3ds->m_VecObject->at(i).Verts.at(j)+
				((Next3DS->m_VecObject->at(i).Verts.at(j)-Current3ds->m_VecObject->at(i).Verts.at(j))
				/m_InterpolationPourcentage)*m_CurrentInterpolation;
				
			//std::cout<<"object copy"<<Tmpt3dobj.Verts.at(j)<<std::endl;
			//std::cout<<"object original"<<Current3ds->m_VecObject->at(i).Verts.at(j)<<std::endl;
			//std::cout<<"----------------------------------------------"<<std::endl;
		}

		Render3DS->m_VecObject->push_back(Tmpt3dobj);		//push the new object data
	}
	m_CurrentInterpolation++;


	Render3DS->Draw();
*/
	/*std::cout<<"vec obj size:"<<Render3DS->m_VecObject->size()<<std::endl;

	for(unsigned int i=0;i<Render3DS->m_VecObject->size();i++)
	{
		std::cout<<"vec vertex size:"<<Render3DS->m_VecObject->at(i).Verts.size()<<std::endl;
		for(unsigned int j;j<Render3DS->m_VecObject->at(i).Verts.size();j++)
		{
			std::cout<<Render3DS->m_VecObject->at(i).Verts.at(j)<<std::endl;
		}
	}*/


	//Render3DS->m_VecObject.at();
	//Current3ds->m_VecObject.at();

//		Render3DS->BuildList(RENDER_TEXTURES);
//		Render3DS->Draw();

/*	ManagerModel->GetObject(Render3DS->GetId())->m_Visible=true;
	ManagerModel->GetObject(Render3DS->GetId())->Draw();
	ManagerModel->GetObject(Render3DS->GetId())->m_Visible=false;
*/
	if(m_HasInterpolation)
	{
		//Creat 3 pointer 
		ExCModel3DS *Current3ds,*Next3DS,*Render3DS;
		Current3ds	=(ExCModel3DS *) ManagerModel->GetObject(m_VecObjectIDKey.at(m_CurrentAnimation).first);
		if(m_CurrentAnimation>=m_NumberKeyFrame-1)
		{
			Next3DS	=(ExCModel3DS *) ManagerModel->GetObject(m_VecObjectIDKey.at(0).first);
		}else
		{
			Next3DS	=(ExCModel3DS *) ManagerModel->GetObject(m_VecObjectIDKey.at(m_CurrentAnimation+1).first);
		}
		
		//init new object
		Render3DS	= new ExCModel3DS;
        Render3DS->m_VecObject=new std::vector<t3DObject>;
		Render3DS->SetManagerTexture(ManagerTexture);

		//copy all data
		for(unsigned int i=0;i<Current3ds->m_VecObject->size();i++)
		{
			t3DObject Tmpt3dobj;
			Tmpt3dobj=Current3ds->m_VecObject->at(i);
			//std::cout<<"copy object:"<<Current3ds->m_VecObject->at(i).Material<<std::endl;
			//std::cout<<"test copy object:"<<Tmpt3dobj.Material<<std::endl;
			//modify objet data
			for(unsigned int j;j<Tmpt3dobj.Verts.size();j++)
			{
				Tmpt3dobj.Verts.at(j)=Current3ds->m_VecObject->at(i).Verts.at(j)+
					((Next3DS->m_VecObject->at(i).Verts.at(j)-Current3ds->m_VecObject->at(i).Verts.at(j))
					/m_InterpolationPourcentage)*m_CurrentInterpolation;

				//std::cout<<"object copy"<<Tmpt3dobj.Verts.at(j)<<std::endl;
				//std::cout<<"object original"<<Current3ds->m_VecObject->at(i).Verts.at(j)<<std::endl;
				//std::cout<<"----------------------------------------------"<<std::endl;
			}

			Render3DS->m_VecObject->push_back(Tmpt3dobj);		//push the new object data
		}
		m_CurrentInterpolation++;

		//draw the object
		Render3DS->m_Visible=true;
		Render3DS->HasList=false;
		Render3DS->Draw();
		//free memory
		//delete Render3DS;	
		//delete Render3DS->m_VecObject;

		
	}else
	{
		///-----------------------------------------
		//To draw witout interpolation
		//------------------------------------------
		ManagerModel->GetObject(m_VecObjectIDKey.at(m_CurrentAnimation).first)->m_Visible=true;
		ManagerModel->GetObject(m_VecObjectIDKey.at(m_CurrentAnimation).first)->Draw();
		ManagerModel->GetObject(m_VecObjectIDKey.at(m_CurrentAnimation).first)->m_Visible=false;
	}

	double currenttime=glutGet(GLUT_ELAPSED_TIME);
	if(currenttime>m_TimeLastKeyFrame+m_TimeForNextFrame)//jump next frame
	{
		m_TimeLastKeyFrame=currenttime;
		m_CurrentAnimation++;
		m_CurrentInterpolation=0;
	}

	if(m_CurrentAnimation>=m_NumberKeyFrame)m_CurrentAnimation=0;
UnGuard
}

bool ExCMesh3ds::Load(std::string FileName)
{
Guard(bool ExCMesh3ds::Load(std::string FileName))
m_CurrentAnimation=0;
char			buffer[255];
#ifdef UNIX_SRC
sprintf(buffer, PREFIX "/ExNihilo/Data/Mesh/%s", FileName.data());
#else
sprintf(buffer, "../Data/Mesh/%s", FileName.data());
#endif
std::ifstream fin;
std::string buffstring;
char b[256];
std::pair<ExNihilo::ExId , int> PEX;
fin.open(buffer,std::ios::in);
if(fin.is_open())
{
	try
	{
		//----Read type
		memset(b,0,255);fin.getline(b,256,'\n');
		//----Read has interpol
		memset(b,0,255);fin.getline(b,256,'\n');
		m_HasInterpolation=(bool)ExNihilo::ExtractIntValueFromSring(b,"<HasInterpolation>","<#HasInterpolation>");
		//----Read numer of key
		memset(b,0,255);fin.getline(b,256,'\n');
		m_NumberKeyFrame=ExNihilo::ExtractFloatValueFromSring(b,"<NumberKeyFrame>","<#NumberKeyFrame>");
			//----Read all frame
		for(int i=0;i<m_NumberKeyFrame;i++)
		{
			memset(b,0,255);
			fin.getline(b,256,'\n');
			try
			{
				buffstring=ExNihilo::ExtracValueFromSring(b,"<KeyFrameFile>","<#KeyFrameFile>");
				PEX.first=ManagerModel->Load(buffstring) ;
				PEX.second=i;
				ManagerModel->GetObject(PEX.first)->m_Visible=false;
				m_VecObjectIDKey.push_back(PEX);
			}catch(ExCExpStringNotFound){}
		}
		fin.close();
	}catch(...){throw ExCExpFileReadError();}
}else throw   ExCExpFileNotFound();	
return true;
UnGuard
}

