/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 

 *
 */

#include "ExCMeshFireEffect.h"

ExCMeshFireEffect::ExCMeshFireEffect()
{
Guard(ExCMeshFireEffect::ExCMeshFireEffect())
	SetName("ExCMeshFireEffect");
	SetType(typeid(this).name());
	m_CurrentAnimationTexture=0;
	m_LastTime=0;
	m_DelayNextFrame=75;
UnGuard
}

ExCMeshFireEffect::~ExCMeshFireEffect()
{
Guard(ExCMeshFireEffect::~ExCMeshFireEffect())
UnGuard
}

void ExCMeshFireEffect::Draw(void)
{
Guard(void ExCMeshFireEffect::Draw(void))
if(!m_Visible)return;
//	std::cout<<"Draw fire MEsh "<<std::endl;
	ExCVec3D v1,v2,v3,v4,up,right,CollisionResult;
	GLfloat viewMatrix[16];
	//glPushMatrix();
	//glPushAttrib(GL_ALL_ATTRIB_BITS);
		glGetFloatv(GL_MODELVIEW_MATRIX, viewMatrix);

			right.SetValue(viewMatrix[0],viewMatrix[4],viewMatrix[8]);
			up.SetValue(viewMatrix[1],viewMatrix[5],viewMatrix[9]);
			
			glEnable(GL_BLEND);
			glBlendFunc(GL_SRC_ALPHA,GL_ONE);
			glEnable(GL_TEXTURE_2D);
			glDisable(GL_LIGHTING);
			glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);
			ManagerTexture->SetCurrentObject(m_VecAnimTexture.at(m_CurrentAnimationTexture));	

		glColor4f(1.0f,1.0f,1.0f,1.0f);

			v1=m_Position+(right+up)*-m_Size;
			v2=m_Position+(right-up)*m_Size;
			v3=m_Position+(right+up)*m_Size;
			v4=m_Position+(up-right)*m_Size;

		glBegin(GL_QUADS);
			glTexCoord2f(0.0f, 0.0f); glVertex3fv(v1.m_Vector);
			glTexCoord2f(1.0f, 0.0f); glVertex3fv(v2.m_Vector);
			glTexCoord2f(1.0f, 1.0f); glVertex3fv(v3.m_Vector);
			glTexCoord2f(0.0f, 1.0f); glVertex3fv(v4.m_Vector);
		glEnd();
		
		glDisable(GL_TEXTURE_2D);
		glDisable(GL_BLEND);
	//glPopAttrib();
	//glPopMatrix();
	if(m_LastTime+m_DelayNextFrame<glutGet(GLUT_ELAPSED_TIME))//next second
	{
		if (m_CurrentAnimationTexture<m_VecAnimTexture.size()-1)
		{
			m_CurrentAnimationTexture++;
		}else m_CurrentAnimationTexture=0;
		m_LastTime=glutGet(GLUT_ELAPSED_TIME);
	}

UnGuard
}

bool ExCMeshFireEffect::Load(std::string FileName)
{
Guard(bool ExCMeshFireEffect::Load(std::string FileName))
	char			buffer[255];
	#ifdef UNIX_SRC
	sprintf(buffer, PREFIX "/ExNihilo/Data/Mesh/%s", FileName.data());
	#else
	sprintf(buffer, "../Data/Mesh/%s", FileName.data());
	#endif
	std::ifstream fin;
	std::string buffstring;
	char b[256];
	fin.open(buffer,std::ios::in);
	if(fin.is_open())
	{
		try
		{
			//----Read type
			memset(b,0,255);
			fin.getline(b,256,'\n');

			//----Read size
			memset(b,0,255);
			fin.getline(b,256,'\n');
			m_Size=ExNihilo::ExtractFloatValueFromSring(b,"<Size>","<#Size>");
			//----Read all frame
			do
			{
				memset(b,0,255);
				fin.getline(b,256,'\n');
				try
				{
					buffstring=ExNihilo::ExtracValueFromSring(b,"<Frame>","<#Frame>");
					//ManagerTexture->Add(buffstring);
					m_VecAnimTexture.push_back(buffstring);
					//std::cout<<ExNihilo::ExtracValueFromSring(b,"<Frame>","<#Frame>")<<std::endl;
				}catch(ExCExpStringNotFound){}
			}while(!fin.eof());
			fin.close();
		}catch(...){throw ExCExpFileReadError();}
	}else throw   ExCExpFileNotFound();	
	return true;
UnGuard
}
