/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 

 *
 */

#include "ExCMeshLOD3ds.h"

ExCMeshLOD3ds::ExCMeshLOD3ds()
{
Guard(ExCMeshLOD3ds::ExCMeshLOD3ds())
	SetName("ExCMeshLOD3ds");
	SetType(typeid(this).name());
UnGuard
}

ExCMeshLOD3ds::~ExCMeshLOD3ds()
{
Guard(ExCMeshLOD3ds::~ExCMeshLOD3ds())
UnGuard
}

void ExCMeshLOD3ds::Draw(void)
{
Guard(void ExCMeshLOD3ds::Draw(void))
if(!m_Visible)return;
	ExCMatrix4x4 MAtrix;
	glGetFloatv(GL_MODELVIEW_MATRIX, MAtrix.m_Matrix);
	std::cout<<MAtrix<<std::endl;
	

	/*m.m_Matrix[0]<<"]"<<"["<<m.m_Matrix[4]<<"]"<<"["<<m.m_Matrix[8]<<"]"<<"["<<m.m_Matrix[12]<<"]|"<<std::endl;
	m.m_Matrix[1]<<"]"<<"["<<m.m_Matrix[5]<<"]"<<"["<<m.m_Matrix[9]<<"]"<<"["<<m.m_Matrix[13]<<"]|"<<std::endl;
	m.m_Matrix[2]<<"]"<<"["<<m.m_Matrix[6]<<"]"<<"["<<m.m_Matrix[10]<<"]"<<"["<<m.m_Matrix[14]<<"]|"<<std::endl;
	*/
	ExCVec3D Vec,Vec2;
	Vec.SetX(MAtrix.m_Matrix[0]+MAtrix.m_Matrix[1]+MAtrix.m_Matrix[2]);
	Vec.SetY(MAtrix.m_Matrix[4]+MAtrix.m_Matrix[5]+MAtrix.m_Matrix[6]);
	Vec.SetZ(MAtrix.m_Matrix[8]+MAtrix.m_Matrix[9]+MAtrix.m_Matrix[10]);

	Vec2.SetValue(MAtrix.m_Matrix[12],MAtrix.m_Matrix[13],MAtrix.m_Matrix[14]);
	std::cout<<Vec2<<std::endl;

	std::cout<<DistanceBeteweenTwoPoint(Vec2,m_Position);

	if(DistanceBeteweenTwoPoint(Vec2,m_Position)>m_DistanceForModel)
	{
		m_LowModel.Draw();return;
	}
	if(DistanceBeteweenTwoPoint(Vec2,m_Position)>m_DistanceForModelHigh)
	{
		m_NormalModel.Draw();return;
	}
	m_HighModel.Draw();
UnGuard
}

bool ExCMeshLOD3ds::Load(std::string FileName)
{
Guard(bool ExCMeshLOD3ds::Load(std::string FileName))
	FileName="../Data/Mesh/"+FileName;
	m_HighLevel=ExNihilo::ExtracStringValueFromFile(FileName,"<ModelHigh>","<#ModelHigh>");
	m_DistanceForModelHigh=ExNihilo::ExtractFloatValueFromFile(FileName,"<DistanceForModelHigh>","<#DistanceForModelHigh>");
	m_NormalLevel=ExNihilo::ExtracStringValueFromFile(FileName,"<Model>","<#Model>");
	m_DistanceForModel=ExNihilo::ExtractFloatValueFromFile(FileName,"<DistanceForModel>","<#DistanceForModel>");
	m_LowLevel=ExNihilo::ExtracStringValueFromFile(FileName,"<ModelLow>","<#ModelLow>");

	m_HighModel.SetManagerTexture(ManagerTexture);
	m_HighModel.Load("../Data/Modeles/"+m_HighLevel);

	m_NormalModel.SetManagerTexture(ManagerTexture);
	m_NormalModel.Load("../Data/Modeles/"+m_NormalLevel);

	m_LowModel.SetManagerTexture(ManagerTexture);
	m_LowModel.Load("../Data/Modeles/"+m_LowLevel);
UnGuard
}
