/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 

 *
 */

#include "ExCMeshSauronEffect.h"

ExCMeshSauronEffect::ExCMeshSauronEffect()
{
Guard(ExCMeshSauronEffect::ExCMeshSauronEffect())
	SetName("ExCMeshSauronEffect");
	SetType(typeid(this).name());

	m_Rayon=20;
	m_Rayon2=4;
	m_NumberFace=16;
	m_Rotation=0;
	m_NumberLayer=3;
	m_SizeBetwenLayer=0.001;
	m_Texture1="wave.dds";
	m_TextureMouvingVec.SetValue(0,-0.0001);
	m_TextureNextMouvingVec.SetValue(0,-0.00005);
	m_Color.SetValue(0.9,0.0,0.0f);
	u=0;
	v=0.0005;
UnGuard
}

ExCMeshSauronEffect::~ExCMeshSauronEffect()
{
Guard(ExCMeshSauronEffect::~ExCMeshSauronEffect())
UnGuard
}

void ExCMeshSauronEffect::Draw(void)
{
Guard(void ExCMeshSauronEffect::Draw(void))
if(!m_Visible)return;

	ExCVec3D	Vec;
	glPushAttrib(GL_ALL_ATTRIB_BITS);
	glPushMatrix();

	glDisable(GL_LIGHTING);
	glColor3f(m_Color.GetX(),m_Color.GetY(),m_Color.GetZ());
	glEnable(GL_TEXTURE_2D);

	for(int j=0;j<m_NumberLayer+0;j++)
	{

	/*	glMatrixMode(GL_TEXTURE);
		glTranslatef((m_TextureMouvingVec.GetX()+(j*m_TextureNextMouvingVec.GetX()))*glutGet(GLUT_ELAPSED_TIME)
			,(m_TextureMouvingVec.GetY()+(j*m_TextureNextMouvingVec.GetY()))*glutGet(GLUT_ELAPSED_TIME),0.0f);
		glRotatef(45,0,0,1);
		glMatrixMode(GL_MODELVIEW);	

		ManagerTexture->SetCurrentObject(m_Texture1);

		glEnable(GL_BLEND);
		glBlendFunc(GL_ONE,GL_ONE);
		glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);
*/
		glBegin(GL_QUADS);
	
		//glActiveTexture(GL_TEXTURE0_ARB);
		glEnable(GL_TEXTURE_2D);
		//glBindTexture(GL_TEXTURE_2D, textureName);
		ManagerTexture->SetTexture(1,"Lotrback2");
		glDisableClientState(GL_TEXTURE_COORD_ARRAY);
		// RGB
		glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_COMBINE_EXT);

		glTexEnvf(GL_TEXTURE_ENV,GL_COMBINE_RGB_EXT,GL_MODULATE);
		glTexEnvf(GL_TEXTURE_ENV,GL_SOURCE0_RGB_EXT,GL_TEXTURE);
		glTexEnvf(GL_TEXTURE_ENV,GL_OPERAND0_RGB_EXT,GL_SRC_COLOR);
		glTexEnvf(GL_TEXTURE_ENV,GL_SOURCE1_RGB_EXT,GL_PREVIOUS_EXT);
		glTexEnvf(GL_TEXTURE_ENV,GL_OPERAND1_RGB_EXT,GL_SRC_COLOR);

		// alpha
		glTexEnvf(GL_TEXTURE_ENV,GL_COMBINE_ALPHA_EXT,GL_REPLACE);
		glTexEnvf(GL_TEXTURE_ENV,GL_SOURCE0_ALPHA_EXT,GL_TEXTURE);
		glTexEnvf(GL_TEXTURE_ENV,GL_OPERAND0_ALPHA_EXT,GL_SRC_ALPHA);

		//glActiveTexture(GL_TEXTURE1_ARB);
		glEnable(GL_TEXTURE_2D);
		//glBindTexture(GL_TEXTURE_2D, textureName);
		ManagerTexture->SetTexture(0,"Lotrback2DOT3");
		glDisableClientState(GL_TEXTURE_COORD_ARRAY);
		// RGB
		glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_COMBINE_EXT);
		glTexEnvf(GL_TEXTURE_ENV,GL_COMBINE_RGB_EXT,GL_REPLACE);
		glTexEnvf(GL_TEXTURE_ENV,GL_SOURCE0_RGB_EXT,GL_PREVIOUS_EXT);
		glTexEnvf(GL_TEXTURE_ENV,GL_OPERAND0_RGB_EXT,GL_SRC_COLOR);

		// alpha
		glTexEnvf(GL_TEXTURE_ENV,GL_COMBINE_ALPHA_EXT,GL_ADD_SIGNED_EXT);
		glTexEnvf(GL_TEXTURE_ENV,GL_SOURCE0_ALPHA_EXT,GL_TEXTURE);
		glTexEnvf(GL_TEXTURE_ENV,GL_OPERAND0_ALPHA_EXT,GL_ONE_MINUS_SRC_ALPHA);
		glTexEnvf(GL_TEXTURE_ENV,GL_SOURCE1_ALPHA_EXT,GL_PREVIOUS_EXT);
		glTexEnvf(GL_TEXTURE_ENV,GL_OPERAND1_ALPHA_EXT,GL_SRC_ALPHA);

		glEnable(GL_BLEND);

		// src * srcAlpha + 0
		glBlendFunc(GL_SRC_ALPHA, GL_ZERO);

		ManagerTexture->SetTextureCoord(0,0.0f, 0.0f); 
		ManagerTexture->SetTextureCoord(1,0.0f, 0.0f); 
		glVertex3f(-10.0f, -10.0f,  1.0f);	// Bottom Left Of The Texture and Quad
		ManagerTexture->SetTextureCoord(0,1.0f, 0.0f); 
		ManagerTexture->SetTextureCoord(1,1.0f, 0.0f); 
		glVertex3f( 10.0f, -10.0f,  1.0f);	// Bottom Right Of The Texture and Quad
		ManagerTexture->SetTextureCoord(0,1.0f, 1.0f); 
		ManagerTexture->SetTextureCoord(1,1.0f, 1.0f); 
		glVertex3f( 10.0f,  10.0f,  1.0f);	// Top Right Of The Texture and Quad
		ManagerTexture->SetTextureCoord(0,0.0f, 1.0f); 
		ManagerTexture->SetTextureCoord(1,0.0f, 1.0f); 
		glVertex3f(-10.0f,  10.0f,  1.0f);	// Top Left Of The Texture and Quad


		glDisable(GL_BLEND);


		glEnd();
/*
		glMatrixMode(GL_TEXTURE);
		glLoadIdentity();
		glMatrixMode(GL_MODELVIEW);*/
	}
ManagerTexture->ResetMultitexture();

	glDisable(GL_TEXTURE_2D);
	glPopMatrix();
	glPopAttrib();
		
UnGuard
}

bool ExCMeshSauronEffect::Load(std::string FileName)
{
Guard(bool ExCMeshSauronEffect::Load(std::string FileName))
	FileName="../Data/Mesh/"+FileName;
	m_NumberFace=ExNihilo::ExtractIntValueFromFile(FileName,"<NumberFace>","<#NumberFace>");
	m_Rayon=ExNihilo::ExtractFloatValueFromFile(FileName,"<Rayon>","<#Rayon>");
	m_NumberLayer=ExNihilo::ExtractIntValueFromFile(FileName,"<NumberLayer>","<#NumberLayer>");
	m_SizeBetwenLayer=ExNihilo::ExtractFloatValueFromFile(FileName,"<SizeBetwenLayer>","<#SizeBetwenLayer>");
	m_Texture1=ExNihilo::ExtracStringValueFromFile(FileName,"<Texture>","<#Texture>");
	m_TextureMouvingVec.SetValue(ExNihilo::ExtractFloatValueFromFile(FileName,"<TextureMouvingVecX>","<#TextureMouvingVecX>"),
								ExNihilo::ExtractFloatValueFromFile(FileName,"<TextureMouvingVecY>","<#TextureMouvingVecY>"));
	m_TextureNextMouvingVec.SetValue(ExNihilo::ExtractFloatValueFromFile(FileName,"<TextureNextMouvingVecX>","<#TextureNextMouvingVecX>"),
									ExNihilo::ExtractFloatValueFromFile(FileName,"<TextureNextMouvingVecY>","<#TextureNextMouvingVecY>"));
	m_Color.SetValue(ExNihilo::ExtractFloatValueFromFile(FileName,"<ColorR>","<#ColorR>")
					,ExNihilo::ExtractFloatValueFromFile(FileName,"<ColorG>","<#ColorG>")
					,ExNihilo::ExtractFloatValueFromFile(FileName,"<ColorB>","<#ColorB>"));
	ManagerTexture->Add(m_Texture1);
	ManagerTexture->Add("Lotrback2");
	ManagerTexture->Add("Lotrback2DOT3");
UnGuard
}
