/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 

 *
 */

#include "ExCMeshSmogEffect.h"

ExCMeshSmogEffect::ExCMeshSmogEffect()
{
Guard(ExCMeshSmogEffect::ExCMeshSmogEffect())
	SetName("ExCMeshSmogEffect");
	SetType(typeid(this).name());
	m_CurrentAnimationTexture=0;
	m_Size=0.1;
UnGuard
}

ExCMeshSmogEffect::~ExCMeshSmogEffect()
{
Guard(ExCMeshSmogEffect::~ExCMeshSmogEffect())
UnGuard
}

void ExCMeshSmogEffect::Draw(void)
{
Guard(void ExCMeshSmogEffect::Draw(void))
if(!m_Visible)return;
	ExCVec3D v1,v2,v3,v4,up,right;
	GLfloat viewMatrix[16];
	glPushMatrix();
	glGetFloatv(GL_MODELVIEW_MATRIX, viewMatrix);

	right.SetValue(viewMatrix[0],viewMatrix[4],viewMatrix[8]);
	up.SetValue(viewMatrix[1],viewMatrix[5],viewMatrix[9]);
	v1=m_Position+(right+up)*-m_Size;
	v2=m_Position+(right-up)*m_Size;
	v3=m_Position+(right+up)*m_Size;
	v4=m_Position+(up-right)*m_Size;

	ManagerTexture->SetCurrentObject("wave.dds");	
	glPushAttrib(GL_ALL_ATTRIB_BITS);
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_LIGHTING);
	glColor4f(1.0f,1.0f,1.0f,1.0f);

	glRotatef(90,0,0,1);

	glBegin(GL_QUADS);
		glTexCoord2f(0.0f, 0.0f); glVertex3fv(v1.m_Vector);
		glTexCoord2f(1.0f, 0.0f); glVertex3fv(v2.m_Vector);
		glTexCoord2f(1.0f, 1.0f); glVertex3fv(v3.m_Vector);
		glTexCoord2f(0.0f, 1.0f); glVertex3fv(v4.m_Vector);
	glEnd();

		glPopAttrib();
	glPopMatrix();
UnGuard
}

bool ExCMeshSmogEffect::Load(std::string FileName)
{
Guard(bool ExCMeshSmogEffect::Load(std::string FileName))
	ManagerTexture->Add("wave.dds");
UnGuard
}
