/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 

 *
 */

#include "ExCMeshSummonCylenderEffect.h"

ExCMeshSummonCylenderEffect::ExCMeshSummonCylenderEffect()
{
Guard(ExCMeshSummonCylenderEffect::ExCMeshSummonCylenderEffect())
	SetName("ExCMeshSummonCylenderEffect");
	SetType(typeid(this).name());
	m_NumberFace=4;
	m_Rayon=10;
	m_Height=150;
	m_NumberCircle=5;
	m_SizeBetwenCircle=2;
	m_Texture="wave.dds";
	m_TextureMouvingVec.SetValue(0,-0.0001);
	m_TextureNextMouvingVec.SetValue(0,0.00005);
	m_StartBlending=0.1f;
	m_BlendingStep=0.5;
	m_Color.SetValue(0.2f,0.2f,0.8f);
UnGuard
}

ExCMeshSummonCylenderEffect::~ExCMeshSummonCylenderEffect()
{
Guard(ExCMeshSummonCylenderEffect::~ExCMeshSummonCylenderEffect())
UnGuard
}

void ExCMeshSummonCylenderEffect::Draw(void)
{
Guard(void ExCMeshSummonCylenderEffect::Draw(void))
if(!m_Visible)return;
	ExCVec3D	Vec;
	glPushAttrib(GL_ALL_ATTRIB_BITS);
	glDisable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);
	glDisable(GL_CULL_FACE);
	//blending
	glEnable(GL_BLEND);
	glBlendFunc(GL_ONE,GL_ONE);
	glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);
	//glTranslatef(0,-6,0);
	for(int j=0;j<m_NumberCircle;j++)
	{
		glColor4f(m_Color.GetX(),m_Color.GetY(),m_Color.GetZ(),m_StartBlending+j*m_BlendingStep);
		ManagerTexture->SetCurrentObject(m_Texture);
		glMatrixMode(GL_TEXTURE);
		glTranslatef((m_TextureMouvingVec.GetX()-(j*m_TextureNextMouvingVec.GetX()))*glutGet(GLUT_ELAPSED_TIME)
			,(m_TextureMouvingVec.GetY()-(j*m_TextureNextMouvingVec.GetY()))*glutGet(GLUT_ELAPSED_TIME),0.0f);
		glMatrixMode(GL_MODELVIEW);	
		glBegin(GL_QUADS);
		for(int i=0;i<m_NumberFace;i++)
		{
				
				glTexCoord2f(1,0);
				Vec.SetX(Cos[(i)*(360/m_NumberFace)]*(m_Rayon+(j*m_SizeBetwenCircle)));
				Vec.SetZ(Sin[(i)*(360/m_NumberFace)]*(m_Rayon+(j*m_SizeBetwenCircle)));
				Vec.SetY(0);
				glVertex3fv(Vec.m_Vector);
				glTexCoord2f(1,1);
				Vec.SetY(m_Height);
				glVertex3fv(Vec.m_Vector);

				glTexCoord2f(0,1);
				Vec.SetX(Cos[(i+1)*(360/m_NumberFace)]*(m_Rayon+(j*m_SizeBetwenCircle)));
				Vec.SetZ(Sin[(i+1)*(360/m_NumberFace)]*(m_Rayon+(j*m_SizeBetwenCircle)));
				Vec.SetY(m_Height);
				
				//glColor4f(0,0,0,m_StartBlending+j*m_BlendingStep);
				
				if(i==m_NumberFace-1)
				{
					Vec.SetX(Cos[(0)*(360/m_NumberFace)]*(m_Rayon+(j*m_SizeBetwenCircle)));
					Vec.SetZ(Sin[(0)*(360/m_NumberFace)]*(m_Rayon+(j*m_SizeBetwenCircle)));
				}
				glVertex3fv(Vec.m_Vector);
				glTexCoord2f(0,0);
				Vec.SetY(0);
				glVertex3fv(Vec.m_Vector);
			
		}
		
		glEnd();
	}
	glMatrixMode(GL_TEXTURE);
	glLoadIdentity();
	glMatrixMode(GL_MODELVIEW);
	
	glDisable(GL_TEXTURE_2D);
	glPopAttrib();
UnGuard
}

bool ExCMeshSummonCylenderEffect::Load(std::string FileName)
{
Guard(bool ExCMeshSummonCylenderEffect::Load(std::string FileName))
	FileName="../Data/Mesh/"+FileName;
	m_NumberFace=ExNihilo::ExtractIntValueFromFile(FileName,"<NumberFace>","<#NumberFace>");
	m_Rayon=ExNihilo::ExtractFloatValueFromFile(FileName,"<Rayon>","<#Rayon>");
	m_Height=ExNihilo::ExtractFloatValueFromFile(FileName,"<Height>","<#Height>");
	m_NumberCircle=ExNihilo::ExtractIntValueFromFile(FileName,"<NumberCircle>","<#NumberCircle>");
	m_SizeBetwenCircle=ExNihilo::ExtractFloatValueFromFile(FileName,"<SizeBetwenCircle>","<#SizeBetwenCircle>");
	m_Texture=ExNihilo::ExtracStringValueFromFile(FileName,"<Texture>","<#Texture>");
	m_TextureMouvingVec.SetValue(ExNihilo::ExtractFloatValueFromFile(FileName,"<TextureMouvingVecX>","<#TextureMouvingVecX>"),
		ExNihilo::ExtractFloatValueFromFile(FileName,"<TextureMouvingVecY>","<#TextureMouvingVecY>"));
	m_TextureNextMouvingVec.SetValue(ExNihilo::ExtractFloatValueFromFile(FileName,"<TextureNextMouvingVecX>","<#TextureNextMouvingVecX>"),
		ExNihilo::ExtractFloatValueFromFile(FileName,"<TextureNextMouvingVecY>","<#TextureNextMouvingVecY>"));
	m_StartBlending=ExNihilo::ExtractFloatValueFromFile(FileName,"<StartBlending>","<#StartBlending>");
	m_BlendingStep=ExNihilo::ExtractFloatValueFromFile(FileName,"<BlendingStep>","<#BlendingStep>");
	m_Color.SetValue(ExNihilo::ExtractFloatValueFromFile(FileName,"<ColorR>","<#ColorR>")
		,ExNihilo::ExtractFloatValueFromFile(FileName,"<ColorG>","<#ColorG>")
		,ExNihilo::ExtractFloatValueFromFile(FileName,"<ColorB>","<#ColorB>"));
	ManagerTexture->Add(m_Texture);
	return true;
UnGuard
}
