/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 

 *
 */

#include "ExCMeshWaterDisqueEffect.h"

ExCMeshWaterDisqueEffect::ExCMeshWaterDisqueEffect()
{
Guard(ExCMeshWaterDisqueEffect::ExCMeshWaterDisqueEffect())
	SetName("ExCMeshWaterDisqueEffect");
	SetType(typeid(this).name());

	m_Rayon=20;
	m_NumberFace=16;
	m_Rotation=0;
	m_NumberLayer=3;
	m_SizeBetwenLayer=0.001;
	m_Texture1="wave.dds";
	m_TextureMouvingVec.SetValue(0,-0.0001);
	m_TextureNextMouvingVec.SetValue(0,-0.00005);
	m_Color.SetValue(0.9,0.0,0.0f);
UnGuard
}

ExCMeshWaterDisqueEffect::~ExCMeshWaterDisqueEffect()
{
Guard(ExCMeshWaterDisqueEffect::~ExCMeshWaterDisqueEffect())
UnGuard
}

void ExCMeshWaterDisqueEffect::Draw(void)
{
Guard(void ExCMeshWaterDisqueEffect::Draw(void))
if(!m_Visible)return;

	ExCVec3D	Vec;
	glPushAttrib(GL_ALL_ATTRIB_BITS);
	glPushMatrix();
	glTranslatef(0,1000,0);
	glDisable(GL_LIGHTING);
	glColor3f(m_Color.GetX(),m_Color.GetY(),m_Color.GetZ());
	glEnable(GL_TEXTURE_2D);

	for(int j=0;j<m_NumberLayer+0;j++)
	{

		glMatrixMode(GL_TEXTURE);
		glTranslatef((m_TextureMouvingVec.GetX()+(j*m_TextureNextMouvingVec.GetX()))*glutGet(GLUT_ELAPSED_TIME)
			,(m_TextureMouvingVec.GetY()+(j*m_TextureNextMouvingVec.GetY()))*glutGet(GLUT_ELAPSED_TIME),0.0f);
		glRotatef(45,0,0,1);
		glMatrixMode(GL_MODELVIEW);	
	
		ManagerTexture->SetCurrentObject(m_Texture1);

		if(j!=0)
		{
			glEnable(GL_BLEND);
			glBlendFunc(GL_ONE,GL_ONE);
			glTexEnvf(GL_TEXTURE_ENV,GL_TEXTURE_ENV_MODE,GL_MODULATE);
		}

		glBegin(GL_QUADS);
		for(int i=0;i<m_NumberFace;i++)
		{
			glColor4f(m_Color.GetX(),m_Color.GetY(),m_Color.GetZ(),1.0f);
			glTexCoord2f(1,1);glVertex3f(0,m_SizeBetwenLayer*j,0);
			
			glColor4f(0,0,0,0.0f);
			glTexCoord2f(0,1);
			Vec.SetX(Cos[(i+1)*(360/m_NumberFace)]*(m_Rayon));
			Vec.SetZ(Sin[(i+1)*(360/m_NumberFace)]*(m_Rayon));
			Vec.SetY(m_SizeBetwenLayer*j);
			if(i==m_NumberFace-1)
			{
				Vec.SetX(Cos[(0)*(360/m_NumberFace)]*(m_Rayon));
				Vec.SetZ(Sin[(0)*(360/m_NumberFace)]*(m_Rayon));
			}
			glVertex3fv(Vec.m_Vector);

			glTexCoord2f(1,0);
			Vec.SetX(Cos[(i)*(360/m_NumberFace)]*(m_Rayon));
			Vec.SetZ(Sin[(i)*(360/m_NumberFace)]*(m_Rayon));
			Vec.SetY(m_SizeBetwenLayer*j);
			glVertex3fv(Vec.m_Vector);

			glColor4f(m_Color.GetX(),m_Color.GetY(),m_Color.GetZ(),1.0f);
			glTexCoord2f(0,0);glVertex3f(0,m_SizeBetwenLayer*j,0);
		}
		glEnd();

		glMatrixMode(GL_TEXTURE);
		glLoadIdentity();
		glMatrixMode(GL_MODELVIEW);
	}


	glDisable(GL_TEXTURE_2D);
	glPopMatrix();
	glPopAttrib();

UnGuard
}

bool ExCMeshWaterDisqueEffect::Load(std::string FileName)
{
Guard(bool ExCMeshWaterDisqueEffect::Load(std::string FileName))
	FileName="../Data/Mesh/"+FileName;
	m_NumberFace=ExNihilo::ExtractIntValueFromFile(FileName,"<NumberFace>","<#NumberFace>");
	m_Rayon=ExNihilo::ExtractFloatValueFromFile(FileName,"<Rayon>","<#Rayon>");
	m_NumberLayer=ExNihilo::ExtractIntValueFromFile(FileName,"<NumberLayer>","<#NumberLayer>");
	m_SizeBetwenLayer=ExNihilo::ExtractFloatValueFromFile(FileName,"<SizeBetwenLayer>","<#SizeBetwenLayer>");
	m_Texture1=ExNihilo::ExtracStringValueFromFile(FileName,"<Texture>","<#Texture>");
	m_TextureMouvingVec.SetValue(ExNihilo::ExtractFloatValueFromFile(FileName,"<TextureMouvingVecX>","<#TextureMouvingVecX>"),
								ExNihilo::ExtractFloatValueFromFile(FileName,"<TextureMouvingVecY>","<#TextureMouvingVecY>"));
	m_TextureNextMouvingVec.SetValue(ExNihilo::ExtractFloatValueFromFile(FileName,"<TextureNextMouvingVecX>","<#TextureNextMouvingVecX>"),
									ExNihilo::ExtractFloatValueFromFile(FileName,"<TextureNextMouvingVecY>","<#TextureNextMouvingVecY>"));
	m_Color.SetValue(ExNihilo::ExtractFloatValueFromFile(FileName,"<ColorR>","<#ColorR>")
					,ExNihilo::ExtractFloatValueFromFile(FileName,"<ColorG>","<#ColorG>")
					,ExNihilo::ExtractFloatValueFromFile(FileName,"<ColorB>","<#ColorB>"));
	ManagerTexture->Add(m_Texture1);
UnGuard
}
