/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/


/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCMeshWaterDisqueEffect.h												*/
/*																		*/
/* Star Date   :03/15/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/     

#ifndef __EXCMESWATERDISQUEEFFECT_H__
#define __EXCMESWATERDISQUEEFFECT_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Object/Object3D/Mesh/ExCMesh.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerTexture.h"
//------------------------------------------------------------------------
#include "Object/Object3D/Gizmo/ExCGizmo.h"
//------------------------------------------------------------------------
class ExCMeshWaterDisqueEffect : public ExCMesh
{
protected:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	int					m_Rotation;
	int					m_NumberFace;
	int					m_NumberLayer;
	float				m_Rayon;
	int					m_NumberCircle;
	float				m_SizeBetwenLayer;
	ExCVec2D			m_TextureMouvingVec;
	ExCVec2D			m_TextureNextMouvingVec;
	std::string			m_Texture1;
	std::string			m_Texture2;
	ExCVec3D			m_Color;
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExCMeshWaterDisqueEffect();
	~ExCMeshWaterDisqueEffect();

//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	void Draw(void);
	bool Load(std::string FileName);
};
//------------------------------------------------------------------------
#endif //__EXCMESWATERDISQUEEFFECT_H__
