/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 

 *
 */

#include "ExCModel.h"

ExCModel::ExCModel()
{
Guard(ExCModel::ExCModel())
	ExCObject3D::ExCObject3D();
UnGuard
}

ExCModel::~ExCModel()
{
Guard(ExCModel::~ExCModel())
UnGuard
}

void ExCModel::Forward(void)
{
Guard(void ExCModel::Forward(void))
	m_Position=m_Position+m_Target;	
UnGuard
}

void ExCModel::Draw(void)
{
Guard(void ExCModel::Draw(void))
	//Calcul new position force vector
	
	ExQuaternion qRotationY,qRotationX,qRotationZ,qresult;
	float matrix[16];

	qRotationX.CreateFromAxisAngle(1, 0, 0, m_Angle.GetX());
	qRotationY.CreateFromAxisAngle(0, 1, 0, m_Angle.GetY());
	qRotationZ.CreateFromAxisAngle(0, 0, 1, m_Angle.GetZ());
	//check if we can move
/*    ExCVec3D CollisionResult;
	CollisionResult=ManagerCollision->ObjectCollision(this);

	if(CollisionResult.GetX()!=0)
	{
		glColor3f(1,0,0);
		m_Position=m_OldPosition;
	}*/
	//m_Target=m_Position+ExCVec3D(Cos[(int)m_AngleY],0.0f,Sin[(int)m_AngleY]);
	if(m_Angle.GetZ()>90&&m_Angle.GetZ()<270)
	{
		m_Target=ExCVec3D(Cos[(int)m_Angle.GetY()],Sin[(int)m_Angle.GetZ()],Sin[(int)m_Angle.GetY()]);
	}else
	{
		m_Target=ExCVec3D(Cos[(int)m_Angle.GetY()],-Sin[(int)m_Angle.GetZ()],Sin[(int)m_Angle.GetY()]);
	}
	m_Velocity=m_Velocity+(m_Acceleration*m_Target)-m_Gravity;
	m_Position=m_Position+m_Velocity;

	/*m_Position=m_Position+(m_Target*m_Velocity);
	ExCVec3D plok;
	plok=m_Target*m_Velocity;
	std::cout<<"ploki"<<std::endl;
	std::cout<<m_Target<<std::endl;
	std::cout<<m_Velocity<<std::endl;
	std::cout<<plok<<std::endl;*/
	//std::cout<<"3ds pos"<<m_Position<<std::endl;
	glTranslatef(m_Position.GetX(),m_Position.GetY(),m_Position.GetZ());
		
	qRotationY.CreateMatrix(matrix);
	glMultMatrixf(matrix);
	qRotationZ.CreateMatrix(matrix);
	glMultMatrixf(matrix);
	qRotationX.CreateMatrix(matrix);
	glMultMatrixf(matrix);
	
UnGuard
}
ExCAction ExCModel::InputAction(ExCAction Action)
{
	return NOTHING;
}
void ExCModel::NextFrame(void)
{
Guard(void ExCModel::NextFrame(void))
	m_CurrentFrames++;
	if(m_CurrentFrames>m_numFrames)m_CurrentFrames=1;
UnGuard
}

void ExCModel::PreviousFrame(void)
{
Guard(void ExCModel::PreviousFrame(void))
	m_CurrentFrames--;
	if(m_CurrentFrames<1)m_CurrentFrames=m_numFrames;
UnGuard
}

void ExCModel::SetCurrentFrame(int frame)
{
Guard(void ExCModel::SetCurrentFrame(int frame))
  if(frame>0&&frame<m_numFrames)
	m_CurrentFrames=frame;
UnGuard
}

void ExCModel::StartRun(void)
{
Guard(void ExCModel::StartRun(void))
 	//m_CurrentFrames=40;
	//m_Transition=true;
UnGuard
}

void ExCModel::StopRun(void)
{
Guard(void ExCModel::StopRun(void))
	//m_CurrentFrames=1;
	//m_Transition=false; 
UnGuard
}

void ExCModel::StartAction(std::string	 Action)
{
Guard(void ExCModel::SStartAction(std::string	 Action))
UnGuard
}

void ExCModel::StopAction(void)
{
Guard(void ExCModel::StopAction(void))
UnGuard
}