/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/


/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCModel.h												*/
/*																		*/
/* Star Date   :03/15/2002												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/     

#ifndef __EXCMODEL_H__
#define __EXCMODEL_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Object/Object3D/ExCObject3D.h"
//------------------------------------------------------------------------
#include "Manager/ManagerObject/ExManagerTexture.h"
//------------------------------------------------------------------------
#include "Object/Object3D/Gizmo/ExCGizmo.h"
//------------------------------------------------------------------------
// Define
//------------------------------------------------------------------------
#define RENDER_TEXTURES_LIGHT		10001
#define RENDER_TEXTURES				10002
#define RENDER_TRIANGLES_LIGHT	    10003
#define RENDER_TRIANGLES			10005
#define RENDER_POINTS				10006
#define RENDER_LINES				10007
#define RENDER_NO					10008

enum 
{ 
	RENDER_VERTEX_ARRAY = 0,
	RENDER_IMMEDIATE_MODE = 1,
	RENDER_DISPLAY_LIST = 2
};

//------------------------------------------------------------------------
class ExCModel : public ExCObject3D
{
protected:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExManagerTexture			*ManagerTexture;
	int							m_CurrentFrames;
	int							m_NextFrame;
	int							m_numFrames;
	float						m_InterpolationPourcentage;  //%
	bool						m_Transition;
	float						m_Interpolation;
	int							m_KeyFrameStartAction;
	int							m_KeyFrameStopAction;
	std::string					m_CurrentAction;
	ExCGizmo					*m_CollisionGizmo;
	int							m_CollisionCounter;

	int							m_RenderMode;
public:
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExCModel();
	~ExCModel();
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	bool m_AlwaysDraw;
	void Draw(void);
	virtual bool Load(std::string FileName){return false;}
	void NextFrame(void);
	void PreviousFrame(void);
	void SetCurrentFrame(int frame);
	inline int GetCurrentFrame(void){return m_CurrentFrames; }
	inline void SetInterpolationPourcentage(float inter){m_InterpolationPourcentage=inter;}
	inline float GetInterpolationPourcentage(void){return m_InterpolationPourcentage;}
	inline void SetManagerTexture(ExManagerTexture * Texture){ManagerTexture = Texture;}
	
	virtual void StopRun(void);
	virtual void StartRun(void);
	virtual void StartAction(std::string	 Action);
	virtual void StopAction(void);
	void Forward(void);
	void Process(std::string	 Action);
	virtual ExCAction InputAction(ExCAction Action);
	inline ExCGizmo * GetCollisionGizmo(void){return m_CollisionGizmo;}
	inline void IncreaseCollisionCouter(void){m_CollisionCounter++;}
	inline void DeCreaseCollisionCouter(void){m_CollisionCounter--;}
	inline void ResetCollisionCouter(void){m_CollisionCounter=0;}
	virtual void CallAllList(void){};

	inline void SetRenderMode(int mode){m_RenderMode = mode;}
};
//------------------------------------------------------------------------
#endif //__EXCMODEL_H__
