/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCModel3DS.h										*/
/*																		*/
/* Start Date   :06/20/2003												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXCMODEL3DS_H__
#define __EXCMODEL3DS_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
#include "Math/ExCFrustum.h"
//------------------------------------------------------------------------
#include "Object/Object3D/Model/ExCModel.h"
//------------------------------------------------------------------------
#include "Object/Object3D/Gizmo/ExCGizmoRectangle.h"
//------------------------------------------------------------------------

//define relative to 3ds file format

//>------ Primary Chunk, at the beginning of each file
#define PRIMARY       0x4D4D
//>------ Main Chunks
#define OBJECTINFO    0x3D3D				// This gives the version of the mesh and is found right before the material and object information
#define EDITKEYFRAME  0xB000				// This is the header for all of the key frame info
#define FILEVERSION   0x0002
//>------ common chunk
#define INT_PERCENTAGE		0x0030
#define PERCENTAGE 			0x0031
//>------ sub defines of OBJECTINFO
#define MATERIAL	  0xAFFF				// This stored the texture info
#define OBJECT		  0x4000				// This stores the faces, vertices, etc...
#define MESH_VERSION  0x3D3E
#define MASTER_SCALE  0x0100

//>------ sub defines of MATERIAL


#define MATNAME				0xA000				// The material name				TYPE:ascii
#define MATAMBIENTCOLOR		0xA010				// The material ambient color		TYPE:s
#define MATDIFFUSE			0xA020				// The material diffuse color		TYPE:s
#define MATSPECULAR			0xA030				// The material specular color		TYPE:s
#define MATSHININESS		0xA040				// The shininess					TYPE:s
#define MATSHININESSSTR		0xA041				// The shininess strenght			TYPE:s
#define MATTRANSPARENCY		0xA050
#define MATTRANSFALLOFF		0xA052
#define MATREFLECTBLUR		0xA053
#define MATTWOSIDED			0xA081
#define MATTRANSPARENCYADD	0xA083
#define MATSELFILUM			0xA084
#define MATWIREON			0xA085
#define MATWIRETHICKNESS	0xA087
#define MATFACEMAP			0xA088
#define MATTRANSFALLOFFIN	0xA08A
#define MATSOFTEN			0xA08C
#define MAT3DWIRETHICKNESS	0xA08E
#define MATTYPE				0xA100
#define MATMAP				0xA200				// This is a header for a new material
#define MATMAPFILE			0xA300				// This holds the file name of the texture
#define MATMAPOPTION		0xA351				
#define MATMAPFILTERINGBLUR	0xA353		


#define OBJECT_MESH   0x4100				// This lets us know that we are reading a new object
//>------ sub defines of OBJECT_MESH
#define OBJECT_VERTICES     0x4110			// The objects vertices
#define OBJECT_FACES		0x4120			// The objects faces
#define OBJECT_MATERIAL		0x4130			// This is found if the object has a material, either texture map or color
#define OBJECT_UV			0x4140			// The UV texture coordinates
#define OBJECT_SMOOTH_GROUP 0x4150
#define OBJECT_MESH_MATRIX	0x4160

struct tChunk
{
	unsigned short int ID;					// The chunk's ID		
	unsigned int length;					// The length of the chunk
	unsigned int bytesRead;					// The amount of bytes read within that chunk
};
struct tFace
{
	int vertIndex[3];			// indicies for the verts that make up this triangle
	int coordIndex[3];			// indicies for the tex coords to texture this face
};
struct tMaterialInfo
{
	char  strName[255];			// The texture name
	char  strFile[255];			// The texture file name (If this is set it's a texture map)
	BYTE  color[3];				// The color of the object (R, G, B)
	int   texureId;				// the texture ID
	float uTile;				// u tiling of texture  (Currently not used)
	float vTile;				// v tiling of texture	(Currently not used)
	float uOffset;			    // u offset of texture	(Currently not used)
	float vOffset;				// v offset of texture	(Currently not used)
} ;
struct t3DObject 
{
	int  numOfVerts;			// The number of verts in the model
	int  numOfFaces;			// The number of faces in the model
	int  numTexVertex;			// The number of texture coordinates
	int  materialID;			// The texture ID to use, which is the index into our texture array
	bool bHasTexture;			// This is TRUE if there is a texture map for this object
	char strName[255];			// The name of the object
	std::string			Material;				
	std::vector<ExCVec3D>  Verts;	// The object's vertices
	std::vector<ExCVec3D>  Normals;	// The object's normals
	std::vector<ExCVec2D>  TexVerts;	// The texture's UV coordinates
	std::vector<tFace>		  Faces;	// The faces information of the object
	
	float	*TabVertices;
	float	*TabTextures;

	ExCGizmoRectangle		m_BoxForFrustrum;
	GLuint					m_ListId;
	GLuint					m_BufferId;
};
//--------------------------------


class ExCModel3DS : public ExCModel
{
protected:
//--------------------------------
// Variable
//--------------------------------
	FILE			*m_filePtr;
//--------------------------------
// Methode
//--------------------------------
	void ReadObjectInfo(tChunk *chunk);
	void ReadObject(tChunk *chunk);
	void ReadObjectMaterial(tChunk *chunk);

	void ReadChunk(tChunk *chunk);
	void Skip(tChunk *chunk);
	
	void ReadVertices(t3DObject *pObject, tChunk *chunk);
	void ReadFace(t3DObject *pObject, tChunk *chunk);
	void ReadUVCoordinates(t3DObject *pObject, tChunk *chunk);
	void ReadObjectMaterial(t3DObject *pObject, tChunk *chunk);

	int numOfObjects;					// The number of objects in the model
	int numOfMaterials;					// The number of materials for the model
	std::vector<tMaterialInfo> m_VecMaterials;	// The list of material information (Textures and colors)
	

	tChunk *m_CurrentChunk;
	tChunk *m_TempChunk;
	GLuint					m_ListId;

	

	float			*m_VertexArray;			//vertex Arrray
	unsigned int	*m_FaceArray;			//Faces Array
	float			*m_TextureArray;		//texture Arrray
	void BuildArray(int Rendu);
	std::vector<std::string> m_VecAction;
	std::vector<std::string>::iterator m_IVecAction;

public:
	bool					HasList;
	bool					HasArray;
	std::vector<t3DObject> *m_VecObject;			// The object list for our model
//--------------------------------
// Constructor  // Destructor
//--------------------------------
	ExCModel3DS(void);
	~ExCModel3DS(void);
//--------------------------------
// Methode
//--------------------------------
	void BuildList(int Rendu);
	void Draw(void);
	void CallAllList(void);
	void CallAllArray(void);
	bool Load(std::string FileName);
	void StartAction(std::string	 Action);
	void StopAction(std::string	 Action);
	void Process(std::string	 Action);
	void ProcessAllAction(void);
	ExCAction InputAction(ExCAction Action);
	bool IsAction(std::string Action);


};
#endif //__EXCMODEL3DS_H__

