/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCModelASC.h											*/
/*																		*/
/* Start Date   :06/20/2003												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXCMODELASC_H__
#define __EXCMODELASC_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Object/Object3D/Model/ExCModel.h"
//------------------------------------------------------------------------
class ExCModelASC : public ExCModel
{
protected:
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
struct MeshAsc
{
	ExCVec3D VecAB,VecBC,VecCA;
	ExCVec2D VecTAB,VecTBC,VecTCA;
	std::string			m_Material;
};


struct ObjAsc
{
	std::vector<ExCVec3D >	m_VecVertex;
	std::vector<ExCVec2D >	m_VecTexture;
	std::vector<ExCVec3D >	m_VecFace;
	std::string				m_Texture;
	std::string				m_ObjectName;
	int						m_Smoothing;
	
	ExCVec3D				m_BoxPoint[8];
};
	
	GLuint					m_ListId;
	ExCVec3D				m_AmbiantLight;
	int						m_NumberObject;
	std::vector<ObjAsc>		m_VecObject;
	std::vector<MeshAsc >	m_VecMesh;
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	void BuildList(int Rendu);
	
public:
//------------------------------------------------------------------------
// Constructor // Destructor
//------------------------------------------------------------------------
	ExCModelASC(void);
	ExCModelASC(std::string FileName);
	~ExCModelASC(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------
	void Draw(void);
	void ProcessLine(std::string Line);
	bool Load(std::string FileName);
};
//------------------------------------------------------------------------
#endif //__EXCMODELASC_H__
