/*
 * ExNihilo 3D Engine
 * 
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * Please read AUTHORS file !!!
 * 

 *
 */

#include "ExCModelEXM.h"

ExCModelEXM::ExCModelEXM(void)
{
Guard(ExCModelEXM::ExCModelEXM(void))
	ExCModel::ExCModel();
	SetName("ExCModelEXM");
	SetType(typeid(this).name());
	m_pFather=NULL;
	m_VecChild=NULL;
	m_CollisionGizmo=new ExCGizmoRectangle;
	m_Lighting=false;
UnGuard
}

ExCModelEXM::~ExCModelEXM(void)
{
Guard(ExCModelEXM::~ExCModelEXM(void))
UnGuard
}

void ExCModelEXM::BuilGizmoBox(void)
{
Guard(void ExCModelEXM::BuilGizmoBox(void))
	
UnGuard
}



void ExCModelEXM::Draw(void)
{
Guard(void ExCModelEXM::Draw(void))
	//----------------------------
	//CREATE CURRENT VERTEX VECTOR
	//----------------------------
	BuildDrawVector();
	//----------------------------
	//DRAW MODEL
	//----------------------------
	/*if(!m_Lighting)*/glDisable(GL_LIGHTING);
	glPushAttrib(GL_ALL_ATTRIB_BITS);
	glPushMatrix();
		ExCModel::Draw();
		//--------------
		//Draw Model with array
		//--------------
		glRotatef(-90,1,0,0);//Align with axe
		glColor3f(1,1,1);
		glPushMatrix();
			//Texture  
			for(unsigned int i=0;i<m_VecTextures.size();i++)
			{
				ManagerTexture->SetTexture(i,m_VecTextures.at(i).data());
				glTexCoordPointer(2,GL_FLOAT,0,TabTextures);
			}
			//Vertex 
			glEnableClientState(GL_VERTEX_ARRAY);
			//glVertexPointer(3,GL_FLOAT,0,TabVertices);
			glDrawArrays( GL_TRIANGLES, 0 , m_numTriangles*3 );
			
			ManagerTexture->ResetMultitexture();
		glPopMatrix();
	glPopAttrib();
	glPopMatrix();
	//glDisable(GL_TEXTURE_2D);
	
	//delete TabCurrentVertices;	
UnGuard
}

void ExCModelEXM::BuildDrawVector(void)
{
Guard(void ExCModelEXM::BuildDrawVector(void))
	ExCVec3D VecAB,VecBC,VecCA;
	TabVertices= new float[m_numTriangles*9];
	int FrameToDraw=1;
	//FrameToDraw=m_VecVertex.size()+10;
	
	std::cout<<"plok m_VecTriangle "<<m_VecTriangle.size()<<std::endl;
	std::cout<<"plok m_VecVertex "<<m_VecVertex.size()<<std::endl;
	for(int i = 0; i < m_numTriangles; i++)
	{
		//std::cout<<"plok gruik"<<std::endl;
		//----------------
		//Vertex coord
		//----------------
		VecAB.SetX(m_VecVertex.at(m_VecTriangle.at(i).first.GetX()+FrameToDraw).GetX());
		VecAB.SetY(m_VecVertex.at(m_VecTriangle.at(i).first.GetX()+FrameToDraw).GetY());
		VecAB.SetZ(m_VecVertex.at(m_VecTriangle.at(i).first.GetX()+FrameToDraw).GetZ());		

		VecBC.SetX(m_VecVertex.at(m_VecTriangle.at(i).first.GetY()+FrameToDraw).GetX());
		VecBC.SetY(m_VecVertex.at(m_VecTriangle.at(i).first.GetY()+FrameToDraw).GetY());
		VecBC.SetZ(m_VecVertex.at(m_VecTriangle.at(i).first.GetY()+FrameToDraw).GetZ());

		VecCA.SetX(m_VecVertex.at(m_VecTriangle.at(i).first.GetZ()+FrameToDraw).GetX());
		VecCA.SetY(m_VecVertex.at(m_VecTriangle.at(i).first.GetZ()+FrameToDraw).GetY());
		VecCA.SetZ(m_VecVertex.at(m_VecTriangle.at(i).first.GetZ()+FrameToDraw).GetZ());
		//std::cout<<"plok"<<std::endl;
		//--------------
		//Build array with new vertex data
		//--------------
		TabVertices[0+i*9]=VecBC.GetX();
		TabVertices[1+i*9]=VecBC.GetY();
		TabVertices[2+i*9]=VecBC.GetZ();
		TabVertices[3+i*9]=VecAB.GetX();
		TabVertices[4+i*9]=VecAB.GetY();
		TabVertices[5+i*9]=VecAB.GetZ();
		TabVertices[6+i*9]=VecCA.GetX();
		TabVertices[7+i*9]=VecCA.GetY();
		TabVertices[8+i*9]=VecCA.GetZ();
		//std::cout<<"gruik"<<std::endl;
	}	
UnGuard
}

bool ExCModelEXM::Load(std::string FileName)
{
Guard(bool ExCModelEXM::Load(std::string FileName))
	//std::cout<<"ExCModelEXM draw"<<std::endl;
	return true;
UnGuard
}