/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCModelMD2.h											*/
/*																		*/
/* Start Date   :06/20/2003												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/

#ifndef __EXCMODELMD2_H__
#define __EXCMODELMD2_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Object/Object3D/Model/ExCModelMD.h"
//------------------------------------------------------------------------
#include "Tools/ExCImageLoader.h"
#include "Object/Object3D/Gizmo/ExCGizmoSphere.h"
#include "Math/ExCFrustum.h"
//--------------------------------
// These are the needed defines for the max values when loading .MD2 files
#define MD2_MAX_TRIANGLES		4096
#define MD2_MAX_VERTICES		2048
#define MD2_MAX_TEXCOORDS		2048
#define MD2_MAX_FRAMES			512
#define MD2_MAX_SKINS			32
#define MD2_MAX_FRAMESIZE		(MD2_MAX_VERTICES * 4 + 128)

// This holds the header information that is read in at the beginning of the file
typedef struct
{
   int ident;		 // identifies as MD2 file "IDP2"
   int version;	 // mine is 8
   int skinwidth;    // width of texture
   int skinheight;   // height of texture
   int framesize;    // number of bytes per frame
   int numSkins;     // number of textures
   int numXYZ;       // number of points
   int numST;        // number of texture
   int numTris;      // number of triangles
   int numGLcmds;
   int numFrames;    // total number of frames
   int offsetSkins;  // offset to skin names (64 bytes each)
   int offsetST;     // offset of texture s-t values
   int offsetTris;   // offset of triangle mesh
   int offsetFrames; // offset of frame data (points)
   int offsetGLcmds; // type of OpenGL commands to use
   int offsetEnd;    // end of file
} modelHeader_t;
// This stores the frames vertices after they have been transformed
// info for a single frame point
typedef struct
{
   short s;
   short t;
} stIndex_t;

typedef struct
{
   unsigned char v[3];
   unsigned char normalIndex;	// not used
} framePoint_t;

// information for a single frame
typedef struct
{
   float scale[3];
   float translate[3];
   char name[16];
   framePoint_t fp[1];
} frame_t;
// data for a single triangle
typedef struct
{
   unsigned short meshIndex[3];		// vertex indices
   unsigned short stIndex[3];		// texture coordinate indices
} mesh_t;
//--------------------------------
class ExCModelMD2 : public ExCModelMD
{
protected:
	int m_magic;					// This is used to identify the file
	int m_version;					// The version number of the file (Must be 8)
	int m_skinWidth;				// The skin width in pixels
	int m_skinHeight;				// The skin height in pixels
	int m_frameSize;				// The size in bytes the frames are
	int m_numSkins;				// The number of skins associated with the model
	int m_numVertices;				// The number of vertices (constant for each frame)
	int m_numTexCoords;			// The number of texture coordinates
	int m_numTriangles;			// The number of faces (polygons)
	int m_numGlCommands;			// The number of gl commands
	//int m_numFrames;				// The number of animation frames
	int m_offsetSkins;				// The offset in the file for the skin data
	int m_offsetTexCoords;			// The offset in the file for the texture data
	int m_offsetTriangles;			// The offset in the file for the face data
	int m_offsetFrames;			// The offset in the file for the frames data
	int m_offsetGlCommands;		// The offset in the file for the gl commands data
	int m_offsetEnd;				// The end of the file offset
	
	float	*TabVertices;
	float	*TabTextures;
	
	int count;

	std::string m_LastAction;
	
	bool m_ShowCollisionSphere;
	double			m_LastTime;
//--------------------------------
// Variable
//--------------------------------
	std::vector<std::string>	m_VecSkin;

	std::vector< std::pair<ExCVec3D , ExCVec3D > >	m_VecTriangle;
	std::vector<ExCVec3D>		m_VecVertex;
	std::string m_Skin;

	std::vector<std::string> m_VecAction;
	std::vector<std::string>::iterator m_IVecAction;
//--------------------------------
// Methode
//--------------------------------
	void BuildSphere(void);
public:
	ExCGizmoSphere	m_CollisionSphere;
//--------------------------------
// Constructor // Destructor
//--------------------------------
	ExCModelMD2(void);
	//ExCModelMD2(const ExCModelMD2& copy);
	~ExCModelMD2(void);
//--------------------------------
// Methode
//--------------------------------
	void Draw(void);
	bool Load(std::string FileName);
	void StartAction(std::string	 Action);
	void StopAction(std::string	 Action);
	void Process(std::string	 Action);
	void ProcessAllAction(void);
	ExCAction InputAction(ExCAction Action);
	bool IsAction(std::string Action);
	void ShowInfo(void);
};
#endif //__EXCMODELMD2_H__

