/************************************************************************/
/* Ex Nihlo Engine by Hermanns Christophe								*/
/************************************************************************/
/* This program is free software; you can redistribute it and/or		*/
/* modify it under the terms of the GNU General Public License			*/
/* as published by the Free Software Foundation; either version 2		*/
/* of the License, or (at your option) any later version.				*/
/*																		*/
/* This program is distributed in the hope that it will be useful,		*/
/* but WITHOUT ANY WARRANTY; without even the implied warranty of		*/
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.					*/
/*																		*/
/* See the GNU General Public License for more details.					*/
/*																		*/
/* You should have received a copy of the GNU General Public License	*/
/* along with this program; if not, write to the Free Software			*/
/* Foundation, Inc., 59 Temple Place - Suite 330,						*/
/* Boston, MA  02111-1307, USA.											*/
/*																		*/
/* If you use a important part of this code please send me a mail		*/
/* I just want to see where my code go thks :)							*/
/************************************************************************/

/************************************************************************/
/* Contact                                                              */  
/************************************************************************/
/* ExNihilo Website :www.ploksoftware.org                               */
/*                                                                      */
/* Hermanns Christophe ExNihilo creator and main programmer             */
/*                                                                      */
/* Mail             : Data@ploksoftware.org								*/
/* ICQ              : 8030901											*/
/* MSN Messenger    : Data_7@hotmail.com								*/
/*                                                                      */
/*                                                                      */
/************************************************************************/

/************************************************************************/
/* File Description             										*/
/************************************************************************/
/* File Name   :ExCParticule.h											*/
/*																		*/
/* Start Date   :06/20/2003												*/
/*																		*/
/* Last Update :06/20/2003                                              */
/*																		*/
/* File Description :													*/
/*                                                                      */
/* For update of this file check : www.ploksoftware.org                 */
/************************************************************************/
 
#ifndef __EXCPARTICULE_H__
#define __EXCPARTICULE_H__
//------------------------------------------------------------------------
//Includes
//------------------------------------------------------------------------
#include "ExDefine.h"
//------------------------------------------------------------------------
#include "Math/ExMath.h"
//------------------------------------------------------------------------
#include "Object/Object3D/ExCObject3D.h"
//------------------------------------------------------------------------
#include "Object/Object3D/Gizmo/ExCGizmoSphere.h"
//------------------------------------------------------------------------
#include "Manager/ExManagerCollision.h"
//------------------------------------------------------------------------
#define PARTICULE_POINT			1
#define PARTICULE_LINE			2
#define PARTICULE_TEXTURE		3
#define PARTICULE_TEXTURE_NV	4
//------------------------------------------------------------------------
class ExCParticule : public ExCObject3D
{
protected:
	ExManagerCollision			*ManagerCollision;
//------------------------------------------------------------------------
// Variable
//------------------------------------------------------------------------
	ExCVec3D		m_Position;
	ExCVec3D		m_Velocity;
	ExCVec3D		m_Acceleration;
	ExCVec3D		m_Gravity;
    float			m_Size;
	float			m_Mass;
	float			m_Growth;
	int				m_LifeSpan;
	int				m_TotalLife;
	int				m_Weight;
	int				m_Type;
	int				m_ColorR;
	int				m_ColorG;
	int				m_ColorB;
	int				m_Blending;
	GLint			m_Texture;		
	std::vector<ExCVec3D>			m_VecPosition;
	std::vector<ExCVec3D>::iterator	m_ItVecPosition;
	ExCGizmoSphere	m_CollisionSphere;

	PFNGLPOINTPARAMETERFEXTPROC  glPointParameterfEXT  ;
	PFNGLPOINTPARAMETERFVEXTPROC glPointParameterfvEXT ;

	PFNGLPOINTPARAMETERINVPROC   glPointParameteriNV   ;
	PFNGLPOINTPARAMETERIVNVPROC  glPointParameterivNV  ;

	float			m_Rotation;
public:
//------------------------------------------------------------------------
// Constructor // Destructor
//------------------------------------------------------------------------
	ExCParticule(void);
	//ExCParticule(const ExCParticule &Particule);
	~ExCParticule(void);
//------------------------------------------------------------------------
// Methode
//------------------------------------------------------------------------

	inline void SetManagerCollision(ExManagerCollision * Collision){ManagerCollision = Collision;}

	void PrecalculeParticuleTrajectory(int start,int end); 
	void ApplyForceToParitcule(ExCVec3D force);

	void Draw(void);
	void SetParticuleType(int type);
	inline int GetParticuleType(void){return m_Type;}
	
	inline void SetParticuleTexture(GLint texture){m_Texture=texture;}

	inline void SetParticuleSize(float Size) {m_Size=Size;}
	inline float	GetParticuleSize(void)	{return m_Size;}

	inline void SetParticuleGrowth(float Growth) {m_Growth=Growth;}
	inline float	GetParticuleGrowth(void)	{return m_Growth;}

	inline void SetParticuleMass(float Mass) {m_Mass=Mass;}
	inline float	GetParticuleMass(void)	{return m_Mass;}

	inline void SetParticuleLife(int life) {m_LifeSpan=life;m_TotalLife=life;}
	inline int	GetParticuleLife(void)	{return m_LifeSpan;}

	inline void SetParticuleWeight(int Weight) {m_Weight=Weight;
	m_CollisionSphere.m_Radius=m_Weight;
	}
	inline int	GetParticuleWeight(void)	{return m_Weight;}
	
	inline void SetParticuleColorR(int ColorR) {m_ColorR=ColorR;}
	inline int	GetParticuleColorR(void)	{return m_ColorR;}

	inline void SetParticuleColorG(int ColorG) {m_ColorG=ColorG;}
	inline int	GetParticuleColorG(void)	{return m_ColorG;}

	inline void SetParticuleColorB(int ColorB) {m_ColorB=ColorB;}
	inline int	GetParticuleColorB(void)	{return m_ColorB;}

	inline void SetParticuleBlending(int Blending) {m_Blending=Blending;}
	inline int	GetParticuleBlending(void)	{return m_Blending;}

	inline void SetParticuleVelocity(ExCVec3D Velocity) {m_Velocity=Velocity;}
	inline ExCVec3D	GetParticuleVelocity(void)	{return m_Velocity;}

	inline void SetParticuleAcceleration(ExCVec3D Acceleration) {m_Acceleration=Acceleration;}
	inline ExCVec3D	GetParticuleAcceleration(void)	{return m_Acceleration;}

	inline void SetParticuleGravity(ExCVec3D Gravity){m_Gravity=Gravity;}
	inline ExCVec3D	GetParticuleGravity(void)	{return m_Gravity;}

	inline void SetParticulePosition(ExCVec3D Position){m_Position=Position;}
	inline ExCVec3D	GetParticulePosition(void)	{return m_Position;}

	inline void DecreaseLifeSpan(void){m_LifeSpan--;}

	ExCVec3D GetPositionNow(void);
};
//------------------------------------------------------------------------
#endif  //__EXCPARTICULE_H__

